/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractMultiElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementOperation;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRuleElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.GuiUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNCommon;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNHedgeRule;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNObject;
import jp.gr.java_conf.ccs2.util.StringUtil;

public abstract class TNElement
extends TNCommon {
    ActionListener addAction;
    ActionListener inserAction;
    ActionListener removeAction;
    ActionListener moveAction;

    public TNElement(TreeNode treeNode, MessageListener messageListener, String string) {
        super(treeNode, messageListener, string);
    }

    protected abstract void setElements(TreeNode[] var1);

    public ElementOperation getElementOperation() {
        if (this.getObject() instanceof ElementOperation) {
            return (ElementOperation)this.getObject();
        }
        return null;
    }

    public TNElement getElParent() {
        if (this.getParent() instanceof TNElement) {
            return (TNElement)this.getParent();
        }
        return null;
    }

    protected ModuleModel getModule() {
        if (this.getElementOperation() != null) {
            return this.getElementOperation().getParentModule();
        }
        return super.getModule();
    }

    protected ActionListener getAddActionListener() {
        if (this.addAction == null) {
            this.addAction = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TNElement.this.menuAdd(actionEvent);
                }
            };
        }
        return this.addAction;
    }

    protected ActionListener getInsertActionListener(ElementOperation elementOperation) {
        final ElementOperation elementOperation2 = elementOperation;
        this.inserAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TNElement.this.menuInsertBefore(actionEvent, elementOperation2);
            }
        };
        return this.inserAction;
    }

    protected ActionListener getRemoveActionListener() {
        if (this.removeAction == null) {
            this.removeAction = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TNElement.this.menuRemove(actionEvent);
                }
            };
        }
        return this.removeAction;
    }

    protected ActionListener getMoveActionListener() {
        if (this.moveAction == null) {
            this.moveAction = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TNElement.this.menuMove(actionEvent);
                }
            };
        }
        return this.moveAction;
    }

    protected static boolean reconnectCheck(ElementOperation elementOperation, ElementOperation elementOperation2, ElementOperation elementOperation3) {
        return elementOperation.acceptOpElement(elementOperation2) && elementOperation2.acceptOpElement(elementOperation3);
    }

    protected static void reconnect(ElementOperation elementOperation, ElementOperation elementOperation2, ElementOperation elementOperation3) {
        elementOperation.removeOpElement(elementOperation3);
        elementOperation.addOpElements(ElementUtil.toArray(elementOperation2));
        if (elementOperation3 instanceof RefElementModel) {
            ObjectModel objectModel = ((RefElementModel)elementOperation3).getAt();
            elementOperation2.addOpElements(ElementUtil.toArray(objectModel));
        } else {
            elementOperation2.addOpElements(ElementUtil.toArray(elementOperation3));
        }
    }

    protected static boolean removeConnectCheck(ElementOperation elementOperation, ElementOperation elementOperation2) {
        if (elementOperation2.getOpElements() == null || elementOperation2.getOpElements().length == 0) {
            return false;
        }
        return elementOperation.acceptOpElement(elementOperation2.getOpElements()[0]);
    }

    protected static void removeConnect(ElementOperation elementOperation, ElementOperation elementOperation2) {
        elementOperation.removeOpElement(elementOperation2);
        elementOperation.addOpElements(elementOperation2.getOpElements());
    }

    protected Object[][] getPopupMenuResource() {
        Object[][] objectArray;
        Object[][] objectArray2 = new Object[][]{new Object[0]};
        if (this.isEditableObject()) {
            objectArray2 = TNElement.makeAddElementMenuResource(this.getElementOperation(), this.getAddActionListener());
            if (this.getObject() instanceof ModuleModel) {
                return objectArray2;
            }
            objectArray2 = TNCommon.appendCustomMenuAfter(objectArray2, new Object[]{null});
        }
        if ((objectArray = this.getElParent().makeInsertMenuResource(this)) != null) {
            objectArray2 = TNCommon.appendCustomMenuAfter(objectArray2, new Object[]{GuiUtil.getSubmenu("InsertBefore", objectArray)});
            objectArray2 = TNCommon.appendCustomMenuAfter(objectArray2, new Object[]{null});
        }
        if (this.getElParent().getElementOperation() instanceof AbstractMultiElementModel && this.getElParent().isEditableObject()) {
            objectArray2 = TNCommon.appendCustomMenusAfter(objectArray2, TNElement.makeOrderChangeMenuResource(this.getElementOperation(), this.getElParent().getElementOperation(), this.getMoveActionListener()));
            objectArray2 = TNCommon.appendCustomMenuAfter(objectArray2, new Object[]{null});
        }
        objectArray2 = TNCommon.appendCustomMenusAfter(objectArray2, this.makeRemoveMenuResource(this.getElementOperation(), this.getElParent().getElementOperation(), this.getRemoveActionListener()));
        return objectArray2;
    }

    protected Object[][] makeInsertMenuResource(TNElement tNElement) {
        if (!this.isEditableObject()) {
            return null;
        }
        return TNElement.makeInsertElementMenuResource(this.getElementOperation(), tNElement.getElementOperation(), this.getInsertActionListener(tNElement.getElementOperation()));
    }

    protected void menuMove(ActionEvent actionEvent) {
        ElementOperation elementOperation = this.getElParent().getElementOperation();
        if (!(elementOperation instanceof AbstractMultiElementModel)) {
            throw new InternalError("Forbidden operation.");
        }
        AbstractMultiElementModel abstractMultiElementModel = (AbstractMultiElementModel)elementOperation;
        if (actionEvent.getActionCommand() == "move_up") {
            abstractMultiElementModel.moveElementUpward(this.getElementOperation());
        } else if (actionEvent.getActionCommand() == "move_down") {
            abstractMultiElementModel.moveElementDownward(this.getElementOperation());
        } else {
            throw new InternalError("no such action command.");
        }
        this.sendTreeChangedMessage();
    }

    protected void menuAdd(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "add_ref") {
            this.addObject((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_ref_reuse") {
            this.addRef((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_mixed") {
            this.addMixed((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_seq") {
            this.addSequence((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_choice") {
            this.addChoice((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_hedge_ref") {
            this.addHedgeRef((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_none") {
            this.addNone((Component)actionEvent.getSource());
        } else if (actionEvent.getActionCommand() == "add_empty") {
            this.addEmpty((Component)actionEvent.getSource());
        } else {
            throw new InternalError("no such action command.");
        }
    }

    protected void menuInsertBefore(ActionEvent actionEvent, ElementOperation elementOperation) {
        if (actionEvent.getActionCommand() == "add_ref") {
            this.insertObject((Component)actionEvent.getSource(), elementOperation);
        } else if (actionEvent.getActionCommand() == "add_mixed") {
            this.insertMixed((Component)actionEvent.getSource(), elementOperation);
        } else if (actionEvent.getActionCommand() == "add_seq") {
            this.insertSequence((Component)actionEvent.getSource(), elementOperation);
        } else if (actionEvent.getActionCommand() == "add_choice") {
            this.insertChoice((Component)actionEvent.getSource(), elementOperation);
        } else {
            throw new InternalError("no such action command.");
        }
    }

    protected void menuRemove(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "remove_branch") {
            this.removeBranch((Component)actionEvent.getSource(), false);
        } else if (actionEvent.getActionCommand() == "remove_connect") {
            this.removeConnect((Component)actionEvent.getSource(), false);
        } else {
            throw new InternalError("no such action command.");
        }
    }

    protected boolean removeConfirm(Component component) {
        Object[] objectArray = new String[]{this.toString()};
        String string = MessageFormat.format(MainApp.getResString("DoYouRemoveElement{0}?"), objectArray);
        int n = JOptionPane.showConfirmDialog(component, string, MainApp.getResString("RemoveConfirm"), 0);
        return n == 0;
    }

    public void removeBranch(Component component, boolean bl) {
        if (!bl && !this.removeConfirm(component)) {
            return;
        }
        this.getElParent().getElementOperation().removeOpElement(this.getElementOperation());
        this.getTNParent().sendTreeChangedMessage();
    }

    public void removeConnect(Component component, boolean bl) {
        if (!bl && !TNElement.removeConnectCheck(this.getElParent().getElementOperation(), this.getElementOperation())) {
            return;
        }
        if (!this.removeConfirm(component)) {
            return;
        }
        TNElement.removeConnect(this.getElParent().getElementOperation(), this.getElementOperation());
        this.getTNParent().sendTreeChangedMessage();
    }

    protected void addObject(Component component) {
        String string = GuiUtil.inputDialog(component, "inputTagName", "addElement");
        if (StringUtil.isNull(string)) {
            return;
        }
        ObjectModel objectModel = ElementUtil.getObject(this.getModule(), string);
        if (this.getElementOperation().acceptOpElement(objectModel)) {
            this.getElementOperation().addOpElements(ElementUtil.toArray(objectModel));
        } else if (this.getElementOperation().acceptOpElement(TNCommon.HEDGEMODEL)) {
            this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getRef(this.getModule(), objectModel)));
        } else {
            throw new InternalError("Forbidden operation. ");
        }
        this.sendTreeChangedMessage();
    }

    protected void insertObject(Component component, ElementOperation elementOperation) {
        if (this.getElementOperation().getOpElements() == null || this.getElementOperation().getOpElements().length == 0) {
            throw new InternalError("Forbidden operation.");
        }
        String string = GuiUtil.inputDialog(component, "inputTagName", "insertElement");
        if (StringUtil.isNull(string)) {
            return;
        }
        ObjectModel objectModel = ElementUtil.getObject(this.getModule(), string);
        if (TNElement.reconnectCheck(this.getElementOperation(), objectModel, elementOperation)) {
            TNElement.reconnect(this.getElementOperation(), objectModel, elementOperation);
        } else if (TNElement.reconnectCheck(this.getElementOperation(), TNCommon.HEDGEMODEL, elementOperation)) {
            TNElement.reconnect(this.getElementOperation(), ElementUtil.getRef(this.getModule(), objectModel), elementOperation);
        } else {
            throw new InternalError("Forbidden operation. ");
        }
        this.sendTreeChangedMessage();
    }

    protected void addRef(Component component) {
        Object object;
        ObjectModel[] objectModelArray;
        if (this.getElementOperation().acceptOpElement(TNCommon.HEDGEMODEL)) {
            objectModelArray = this.getModule().getAllObjects();
            String[] stringArray = new String[objectModelArray.length];
            int n = 0;
            while (n < objectModelArray.length) {
                object = objectModelArray[n].getTagName();
                if (!objectModelArray[n].isLabelEqTag()) {
                    object = (String)object + " : (label=" + objectModelArray[n].getLabel() + ")";
                }
                stringArray[n] = object;
                ++n;
            }
            object = new SelectionDialog(JOptionPane.getFrameForComponent(component), MainApp.getResString("selectElement"), Arrays.asList(stringArray));
            ((Dialog)object).show();
            if (((SelectionDialog)object).getIndex() == -1) {
                return;
            }
        } else {
            throw new InternalError("Forbidden operation.");
        }
        this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getRef(this.getModule(), objectModelArray[((SelectionDialog)object).getIndex()])));
        this.sendTreeChangedMessage();
    }

    protected void addMixed(Component component) {
        this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getMixed(this.getModule())));
        this.sendTreeChangedMessage();
    }

    protected void insertMixed(Component component, ElementOperation elementOperation) {
        if (this.getElementOperation().getOpElements() == null || this.getElementOperation().getOpElements().length == 0) {
            throw new InternalError("Forbidden operation.");
        }
        if (!TNElement.reconnectCheck(this.getElementOperation(), TNCommon.ELEMENTMODEL, elementOperation)) {
            throw new InternalError("Forbidden operation. ");
        }
        TNElement.reconnect(this.getElementOperation(), ElementUtil.getMixed(this.getModule()), elementOperation);
        this.sendTreeChangedMessage();
    }

    protected void insertSequence(Component component, ElementOperation elementOperation) {
        if (this.getElementOperation().getOpElements() == null || this.getElementOperation().getOpElements().length == 0) {
            throw new InternalError("Forbidden operation.");
        }
        if (!TNElement.reconnectCheck(this.getElementOperation(), TNCommon.HEDGEMODEL, elementOperation)) {
            throw new InternalError("Forbidden operation. ");
        }
        TNElement.reconnect(this.getElementOperation(), ElementUtil.getSequence(this.getModule()), elementOperation);
        this.sendTreeChangedMessage();
    }

    protected void insertChoice(Component component, ElementOperation elementOperation) {
        if (this.getElementOperation().getOpElements() == null || this.getElementOperation().getOpElements().length == 0) {
            throw new InternalError("Forbidden operation.");
        }
        if (!TNElement.reconnectCheck(this.getElementOperation(), TNCommon.HEDGEMODEL, elementOperation)) {
            throw new InternalError("Forbidden operation. ");
        }
        TNElement.reconnect(this.getElementOperation(), ElementUtil.getChoice(this.getModule()), elementOperation);
        this.sendTreeChangedMessage();
    }

    protected void addChoice(Component component) {
        this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getChoice(this.getModule())));
        this.sendTreeChangedMessage();
    }

    protected void addSequence(Component component) {
        this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getSequence(this.getModule())));
        this.sendTreeChangedMessage();
    }

    protected HedgeRuleElementModel chooseHedgeRule(Component component) {
        Object object;
        TNCommon tNCommon = this;
        HedgeRuleElementModel hedgeRuleElementModel = null;
        while (tNCommon != null) {
            if (tNCommon instanceof TNHedgeRule) {
                hedgeRuleElementModel = (HedgeRuleElementModel)tNCommon.getObject();
                break;
            }
            if (tNCommon instanceof TNObject) break;
            tNCommon = tNCommon.getTNParent();
        }
        HedgeRuleElementModel[] hedgeRuleElementModelArray = this.getModule().getAllHedgeRules(hedgeRuleElementModel);
        String[] stringArray = new String[hedgeRuleElementModelArray.length];
        int n = 0;
        while (n < hedgeRuleElementModelArray.length) {
            object = hedgeRuleElementModelArray[n].getLabel();
            stringArray[n] = object;
            ++n;
        }
        object = new SelectionDialog(JOptionPane.getFrameForComponent(component), MainApp.getResString("selectHedgeRule"), Arrays.asList(stringArray));
        ((Dialog)object).show();
        if (((SelectionDialog)object).getIndex() == -1) {
            return null;
        }
        return hedgeRuleElementModelArray[((SelectionDialog)object).getIndex()];
    }

    protected void addHedgeRef(Component component) {
        HedgeRuleElementModel hedgeRuleElementModel;
        if (this.getElementOperation().acceptOpElement(TNCommon.HEDGEMODEL)) {
            hedgeRuleElementModel = this.chooseHedgeRule(component);
            if (hedgeRuleElementModel == null) {
                return;
            }
        } else {
            throw new InternalError("Forbidden operation.");
        }
        this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getHedgeRef(this.getModule(), hedgeRuleElementModel)));
        this.sendTreeChangedMessage();
    }

    protected void addNone(Component component) {
        this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getNone(this.getModule())));
        this.sendTreeChangedMessage();
    }

    protected void addEmpty(Component component) {
        this.getElementOperation().addOpElements(ElementUtil.toArray(ElementUtil.getEmpty(this.getModule())));
        this.sendTreeChangedMessage();
    }

    public static Object[][] makeOrderChangeMenuResource(ElementOperation elementOperation, ElementOperation elementOperation2, ActionListener actionListener) {
        if (!(elementOperation2 instanceof AbstractMultiElementModel)) {
            throw new InternalError("Forbidden operation.");
        }
        AbstractMultiElementModel abstractMultiElementModel = (AbstractMultiElementModel)elementOperation2;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(new Object[]{"moveUpward", "move_up", actionListener, MainApp.getResString("IconMoveUp"), abstractMultiElementModel.canMoveElementUpward(elementOperation) ? Boolean.TRUE : Boolean.FALSE});
        arrayList.add(new Object[]{"moveDownward", "move_down", actionListener, MainApp.getResString("IconMoveDown"), abstractMultiElementModel.canMoveElementDownward(elementOperation) ? Boolean.TRUE : Boolean.FALSE});
        Object[][] objectArrayArray = new Object[arrayList.size()][];
        return (Object[][])arrayList.toArray((T[])objectArrayArray);
    }

    public static Object[][] makeAddElementMenuResource(ElementOperation elementOperation, ActionListener actionListener) {
        Boolean bl = elementOperation.canAddElement() ? Boolean.TRUE : Boolean.FALSE;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        if (elementOperation.acceptOpElement(TNCommon.OBJECTMODEL)) {
            arrayList.add(new Object[]{"addElement", "add_ref", actionListener, MainApp.getResString("IconElement"), bl});
        }
        if (elementOperation.acceptOpElement(TNCommon.HEDGEMODEL)) {
            arrayList.add(new Object[]{"addRefElement", "add_ref_reuse", actionListener, MainApp.getResString("IconRef"), bl});
        }
        if (elementOperation.acceptOpElement(TNCommon.ELEMENTMODEL)) {
            arrayList.add(new Object[]{"addMixed", "add_mixed", actionListener, MainApp.getResString("IconMixed"), bl});
        }
        if (elementOperation.acceptOpElement(TNCommon.HEDGEMODEL)) {
            arrayList.add(new Object[]{"addSequence", "add_seq", actionListener, MainApp.getResString("IconSequence"), bl});
            arrayList.add(new Object[]{"addChoice", "add_choice", actionListener, MainApp.getResString("IconChoice"), bl});
            arrayList.add(new Object[]{"addHedgeRef", "add_hedge_ref", actionListener, MainApp.getResString("IconHedgeRef"), bl});
            arrayList.add(new Object[]{"addNone", "add_none", actionListener, MainApp.getResString("IconNone"), bl});
            arrayList.add(new Object[]{"addEmpty", "add_empty", actionListener, MainApp.getResString("IconEmpty"), bl});
        }
        Object[][] objectArrayArray = new Object[arrayList.size()][];
        return (Object[][])arrayList.toArray((T[])objectArrayArray);
    }

    public static Object[][] makeInsertElementMenuResource(ElementOperation elementOperation, ElementOperation elementOperation2, ActionListener actionListener) {
        if (elementOperation2 == null) {
            throw new InternalError("Object is null. (should be forbedden this operation)");
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        if (TNElement.reconnectCheck(elementOperation, TNCommon.OBJECTMODEL, elementOperation2)) {
            arrayList.add(new Object[]{"insertElement", "add_ref", actionListener, MainApp.getResString("IconElement"), Boolean.TRUE});
        }
        if (TNElement.reconnectCheck(elementOperation, TNCommon.ELEMENTMODEL, elementOperation2)) {
            arrayList.add(new Object[]{"insertMixed", "add_mixed", actionListener, MainApp.getResString("IconMixed"), Boolean.TRUE});
        }
        if (TNElement.reconnectCheck(elementOperation, TNCommon.HEDGEMODEL, elementOperation2)) {
            arrayList.add(new Object[]{"insertSequence", "add_seq", actionListener, MainApp.getResString("IconSequence"), Boolean.TRUE});
            arrayList.add(new Object[]{"insertChoice", "add_choice", actionListener, MainApp.getResString("IconChoice"), Boolean.TRUE});
        }
        Object[][] objectArrayArray = new Object[arrayList.size()][];
        return (Object[][])arrayList.toArray((T[])objectArrayArray);
    }

    Object[][] makeRemoveMenuResource(ElementOperation elementOperation, ElementOperation elementOperation2, ActionListener actionListener) {
        if (!this.getElParent().isEditableObject()) {
            return null;
        }
        Object[][] objectArrayArray = null;
        if (this.isEditableObject()) {
            objectArrayArray = new Object[][]{{"RemoveConnect", "remove_connect", actionListener, MainApp.getResString("IconEditRemoveThis"), TNElement.removeConnectCheck(elementOperation2, elementOperation) ? Boolean.TRUE : Boolean.FALSE}, {"RemoveBranch", "remove_branch", actionListener, MainApp.getResString("IconEditRemoveBranch"), Boolean.TRUE}};
        } else if (this.getElementOperation() instanceof ObjectModel) {
            objectArrayArray = new Object[][]{{"RemoveBranch", "remove_branch", actionListener, MainApp.getResString("IconEditRemoveBranch"), Boolean.TRUE}};
        }
        return objectArrayArray;
    }
}

