/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.HedgeRuleElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNElement;

public class TNHedgeRule
extends TNElement {
    HedgeRuleElementModel hedgeRule;
    JPanel panel = null;
    JTextField nameField;
    JTextArea commentField;

    public TNHedgeRule(TreeNode treeNode, MessageListener messageListener, HedgeRuleElementModel hedgeRuleElementModel) {
        super(treeNode, messageListener, "IconHedgeRule");
        this.hedgeRule = hedgeRuleElementModel;
    }

    protected void setElements(TreeNode[] treeNodeArray) {
        this.setChildren(treeNodeArray);
    }

    public void removeBranch(Component component, boolean bl) {
        if (!bl && !this.removeConfirm(component)) {
            return;
        }
        ModuleModel moduleModel = this.getModule();
        moduleModel.removeHedgeRule(this.hedgeRule);
        this.getTNParent().sendTreeChangedMessage();
    }

    public JPanel getPropertyPane() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.nameField = new JTextField(20);
            this.panel.add(this.setupComponent(this.nameField, "HedgeRuleLabel"));
            this.commentField = new JTextArea(3, 20);
            this.panel.add(this.setupTextArea(this.commentField, "HedgeRuleComment"));
        }
        this.updateComponentsFromData();
        return this.panel;
    }

    protected void updateDataFromComponents() {
        this.hedgeRule.setLabel(this.nameField.getText());
        this.hedgeRule.setComment(this.commentField.getText());
        this.sendRepaintMessage();
    }

    protected void updateComponentsFromData() {
        this.nameField.setText(this.hedgeRule.getLabel());
        this.commentField.setText(this.hedgeRule.getComment());
    }

    public Object getObject() {
        return this.hedgeRule;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public String toString() {
        return "[" + this.hedgeRule.getLabel() + "]";
    }
}

