/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.ModuleModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNCommon;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNElement;

public class TNModule
extends TNElement {
    ModuleModel module;
    JPanel panel = null;
    JTextField verField;
    JTextField cverField;
    JTextField nsField;
    JTextArea commentField;

    public TNModule(ModuleModel moduleModel, MessageListener messageListener) {
        super(null, messageListener, "IconModule");
        this.module = moduleModel;
    }

    protected TNModule(ModuleModel moduleModel, TNModule tNModule, MessageListener messageListener) {
        super(tNModule, messageListener, "IconModule");
        this.module = moduleModel;
    }

    protected void setElements(TreeNode[] treeNodeArray) {
        this.setChildren(treeNodeArray);
    }

    public Object getObject() {
        return this.module;
    }

    protected ModuleModel getMainModule() {
        return this.module;
    }

    protected Object[][] getPopupMenuResource() {
        Object[][] objectArray = super.getPopupMenuResource();
        Object[][] objectArray2 = new Object[][]{{null}, {"IncludeModule", "include_module", this.getAddActionListener(), MainApp.getResString("IconIncludeModule"), Boolean.TRUE}};
        return TNCommon.appendCustomMenusAfter(objectArray, objectArray2);
    }

    protected void menuAdd(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "include_module") {
            JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
            jFileChooser.setFileFilter(MainApp.getRelaxFileFilter());
            int n = jFileChooser.showOpenDialog((Component)actionEvent.getSource());
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                try {
                    this.module.addIncludeModule(ModuleModel.loadModuleFromRelax(file.getPath()));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog((Component)actionEvent.getSource(), iOException.getMessage(), MainApp.getResString("ErrorDialog"), 0);
                }
                this.sendTreeChangedMessage();
            }
            return;
        }
        super.menuAdd(actionEvent);
    }

    public JPanel getPropertyPane() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.commentField = new JTextArea(3, 20);
            this.panel.add(this.setupTextArea(this.commentField, "moduleComment"));
            this.verField = new JTextField(8);
            this.panel.add(this.setupComponent(this.verField, "moduleVersion"));
            this.nsField = new JTextField(20);
            this.panel.add(this.setupComponent(this.nsField, "moduleNameSpace"));
            this.cverField = new JTextField(8);
            this.panel.add(this.setupComponent(this.cverField, "moduleCoreVersion"));
        }
        this.updateComponentsFromData();
        return this.panel;
    }

    protected void updateDataFromComponents() {
        this.module.setModuleComment(this.commentField.getText());
        this.module.setModuleVersion(this.verField.getText());
        this.module.setTargetNameSpace(this.nsField.getText());
        this.module.setRelaxCoreVersion(this.cverField.getText());
    }

    protected void updateComponentsFromData() {
        this.commentField.setText(this.module.getModuleComment());
        this.verField.setText(this.module.getModuleVersion());
        this.nsField.setText(this.module.getTargetNameSpace());
        this.cverField.setText(this.module.getRelaxCoreVersion());
    }

    public String toString() {
        return "[Module]";
    }
}

