/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.tool.mkrelax.AbstractElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributePoolModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.AttributeRefModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.ConcreteAttributeModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.DataType;
import jp.gr.java_conf.ccs2.tool.mkrelax.ElementUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.ObjectModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.RefElementModel;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.GuiUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNAttributeRef;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNCommon;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNConAttribute;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.TNElement;

public class TNObject
extends TNElement {
    boolean shadow = false;
    ObjectModel object;
    RefElementModel ref = null;
    JPanel panel = null;
    JButton typeButton;
    JComboBox occursBox;
    JCheckBox exportCheck;
    JTextField tagField;
    JTextField labelField;
    JTextArea commentField;

    public TNObject(TreeNode treeNode, MessageListener messageListener, ObjectModel objectModel) {
        this(treeNode, messageListener, objectModel, false);
    }

    public TNObject(TreeNode treeNode, MessageListener messageListener, ObjectModel objectModel, boolean bl) {
        super(treeNode, messageListener, "IconElement");
        this.object = objectModel;
        this.shadow = bl;
    }

    protected void setRef(RefElementModel refElementModel) {
        this.ref = refElementModel;
    }

    public RefElementModel getRef() {
        return this.ref;
    }

    public Object getObject() {
        return this.object;
    }

    boolean isShadow() {
        return this.shadow;
    }

    protected void setElements(TreeNode[] treeNodeArray) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        AttributeModel[] attributeModelArray = this.object.getAttributes();
        int n = 0;
        while (n < attributeModelArray.length) {
            if (attributeModelArray[n] instanceof ConcreteAttributeModel) {
                arrayList.add(new TNConAttribute((TreeNode)this, this.getMessageListener(), (ConcreteAttributeModel)attributeModelArray[n]));
            } else if (attributeModelArray[n] instanceof AttributeRefModel) {
                arrayList.add(new TNAttributeRef((TreeNode)this, this.getMessageListener(), (AttributeRefModel)attributeModelArray[n]));
            }
            ++n;
        }
        if (treeNodeArray != null && treeNodeArray.length != 0) {
            arrayList.add(treeNodeArray[0]);
        }
        TreeNode[] treeNodeArray2 = new TreeNode[arrayList.size()];
        treeNodeArray2 = arrayList.toArray(treeNodeArray2);
        this.setChildren(treeNodeArray2);
    }

    public JPanel getPropertyPane() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            Object[] objectArray = new String[]{this.object.getParentModule().getModuleName()};
            this.panel.add(new JLabel(MessageFormat.format(MainApp.getResString("BelongTo{0}"), objectArray)));
            this.tagField = new JTextField(20);
            this.panel.add(this.setupComponent(this.tagField, "objectTag"));
            this.labelField = new JTextField(20);
            this.panel.add(this.setupComponent(this.labelField, "objectLabel"));
            this.commentField = new JTextArea(3, 20);
            this.panel.add(this.setupTextArea(this.commentField, "objectComment"));
            this.occursBox = new JComboBox<String>(AbstractElementModel.occurSymbols);
            this.panel.add(this.setupComponent(this.occursBox, "objectOccurs"));
            this.exportCheck = new JCheckBox();
            this.panel.add(this.setupComponent(this.exportCheck, "objectExport"));
            this.typeButton = new JButton("-----");
            this.typeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TNObject.this.selectDataType();
                }
            });
            this.panel.add(this.setupButton(this.typeButton, "objectType"));
        }
        this.updateComponentsFromData();
        return this.panel;
    }

    void selectDataType() {
        SelectionDialog selectionDialog = new SelectionDialog(JOptionPane.getFrameForComponent(this.typeButton), MainApp.getResString("selectDataType"), Arrays.asList(DataType.dataTypes));
        selectionDialog.show();
        if (selectionDialog.getIndex() == -1) {
            return;
        }
        this.typeButton.setText(DataType.dataTypes[selectionDialog.getIndex()].getTypeName());
        this.object.setType(DataType.dataTypes[selectionDialog.getIndex()]);
        this.clearPopupMenu();
        this.sendRepaintMessage();
    }

    protected void updateDataFromComponents() {
        this.object.setTagName(this.tagField.getText());
        this.object.setLabel(this.labelField.getText());
        this.object.setComment(this.commentField.getText());
        if (this.ref != null) {
            this.ref.setOccurs(this.occursBox.getSelectedIndex());
        }
        this.object.setExportable(this.exportCheck.isSelected());
        this.sendRepaintMessage();
    }

    protected void updateComponentsFromData() {
        this.tagField.setText(this.object.getTagName());
        this.labelField.setText(this.object.getLabel());
        this.commentField.setText(this.object.getComment());
        if (this.ref != null) {
            this.occursBox.setSelectedIndex(this.ref.getOccurs());
        }
        this.exportCheck.setSelected(this.object.isExportable());
        this.typeButton.setText(this.object.getType().getTypeName());
        this.typeButton.setEnabled(this.object.getElement() == null && this.isEditableObject());
        this.occursBox.setEnabled(this.ref != null && this.getElParent().isEditableObject());
    }

    protected Object[][] getPopupMenuResource() {
        Object[][] objectArray = super.getPopupMenuResource();
        if (this.isEditableObject()) {
            Object[][] objectArray2 = new Object[][]{{"addAttribute", "add_attr", this.getAddActionListener(), MainApp.getResString("IconAttribute"), Boolean.TRUE}, {"addAttributeRef", "add_attr_ref", this.getAddActionListener(), MainApp.getResString("IconAttPoolRef"), Boolean.TRUE}, {null}};
            objectArray = TNCommon.appendCustomMenusBefore(objectArray, objectArray2);
        }
        return objectArray;
    }

    protected void menuAdd(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "add_attr") {
            this.addAttribute();
        } else if (actionEvent.getActionCommand() == "add_attr_ref") {
            this.addAttributeRef((Component)actionEvent.getSource());
        } else {
            super.menuAdd(actionEvent);
        }
    }

    void addAttribute() {
        GuiUtil.addAttribute(this.popMenu, this.object);
        this.sendTreeChangedMessage();
    }

    void addAttributeRef(Component component) {
        AttributePoolModel attributePoolModel = this.chooseAttributePool(component);
        if (attributePoolModel == null) {
            return;
        }
        this.object.addAttribute(ElementUtil.getAttributeRef(attributePoolModel));
        this.sendTreeChangedMessage();
    }

    public String toString() {
        String string = this.object.getTagName();
        if (!this.object.isLabelEqTag()) {
            string = string + "(" + this.object.getLabel() + ")";
        }
        string = "<" + string;
        if (this.shadow) {
            string = string + "...(nested) ";
        } else {
            if (this.object.getType() != DataType.RLX_ELEMENT) {
                string = string + " : " + this.object.getType().getTypeName();
            }
            if (this.ref != null) {
                if (this.ref.getOccurs() != 0) {
                    string = string + " [" + this.ref.getOccurSymbol() + "]";
                }
            }
        }
        string = string + ">";
        return string;
    }
}

