/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.RStack;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.UJAXP;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Description
implements Serializable {
    private String content_;
    private String lang_;

    public Description() {
    }

    public Description(RStack rStack) {
        this.setup(rStack);
    }

    public Description(Document document) {
        this.setup(document.getDocumentElement());
    }

    public Description(Element element) {
        this.setup(element);
    }

    public Description(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Description(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public Description(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public Description(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public Description(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public Description(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.setup(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.lang_ = URelaxer.getAttributePropertyAsString(element, "lang");
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("description");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.lang_ != null) {
            URelaxer.setAttributePropertyByString(element, "lang", this.lang_);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 1));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 1));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 1));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 1));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 1));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String string) {
        this.content_ = string;
    }

    public final String getLang() {
        return this.lang_;
    }

    public final void setLang(String string) {
        this.lang_ = string;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<description");
        if (this.lang_ != null) {
            stringBuffer.append(" lang=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(this.getLang()));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(URelaxer.escapeCharData(this.getContent()));
        stringBuffer.append("</description>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<description");
        if (this.lang_ != null) {
            printWriter.print(" lang=\"");
            printWriter.print(URelaxer.escapeAttrQuot(this.getLang()));
            printWriter.print("\"");
        }
        printWriter.print(">");
        printWriter.print(URelaxer.escapeCharData(this.getContent()));
        printWriter.print("</description>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "description")) {
            return false;
        }
        RStack rStack = new RStack(element);
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return Description.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (Description.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

