/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.Description;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.RStack;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.UJAXP;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Option
implements Serializable {
    private String default_;
    private String name_;
    private Boolean force_;
    private List description_ = new ArrayList();

    public Option() {
    }

    public Option(RStack rStack) {
        this.setup(rStack);
    }

    public Option(Document document) {
        this.setup(document.getDocumentElement());
    }

    public Option(Element element) {
        this.setup(element);
    }

    public Option(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Option(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public Option(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public Option(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public Option(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public Option(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.setup(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.default_ = URelaxer.getAttributePropertyAsString(element, "default");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.force_ = URelaxer.getAttributePropertyAsBooleanObject(element, "force");
        this.description_.clear();
        while (!rStack.isEmptyElement()) {
            if (!Description.isMatch(rStack)) break;
            this.addDescription(new Description(rStack));
        }
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("option");
        URelaxer.setAttributePropertyByString(element, "default", this.default_);
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        if (this.force_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "force", this.force_);
        }
        int n = this.description_.size();
        int n2 = 0;
        while (n2 < n) {
            Description description = (Description)this.description_.get(n2);
            description.makeElement(element);
            ++n2;
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 1));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 1));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 1));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 1));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 1));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final String getDefault() {
        return this.default_;
    }

    public final void setDefault(String string) {
        this.default_ = string;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String string) {
        this.name_ = string;
    }

    public boolean getForce() throws IllegalStateException {
        if (this.force_ == null) {
            throw new IllegalStateException("force_");
        }
        return this.force_;
    }

    public Boolean getForceAsBoolean() throws IllegalStateException {
        return this.force_;
    }

    public boolean checkForce() {
        return this.force_ != null;
    }

    public void setForce(boolean bl) {
        this.force_ = new Boolean(bl);
    }

    public void setForce(Boolean bl) {
        this.force_ = bl;
    }

    public final Description[] getDescription() {
        Description[] descriptionArray = new Description[this.description_.size()];
        return this.description_.toArray(descriptionArray);
    }

    public final void setDescription(Description[] descriptionArray) {
        this.description_.clear();
        this.description_.addAll(Arrays.asList(descriptionArray));
    }

    public final void setDescription(Description description) {
        this.description_.clear();
        this.description_.add(description);
    }

    public final void addDescription(Description description) {
        this.description_.add(description);
    }

    public final int getDescriptionCount() {
        return this.description_.size();
    }

    public final Description getDescription(int n) {
        return (Description)this.description_.get(n);
    }

    public final void setDescription(int n, Description description) {
        this.description_.set(n, description);
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<option");
        stringBuffer.append(" default=\"");
        stringBuffer.append(URelaxer.escapeAttrQuot(this.getDefault()));
        stringBuffer.append("\"");
        stringBuffer.append(" name=\"");
        stringBuffer.append(URelaxer.escapeAttrQuot(this.getName()));
        stringBuffer.append("\"");
        if (this.force_ != null) {
            stringBuffer.append(" force=\"");
            stringBuffer.append(new Boolean(this.getForce()).toString());
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        int n = this.description_.size();
        int n2 = 0;
        while (n2 < n) {
            Description description = (Description)this.description_.get(n2);
            description.makeTextElement(stringBuffer);
            ++n2;
        }
        stringBuffer.append("</option>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<option");
        printWriter.print(" default=\"");
        printWriter.print(URelaxer.escapeAttrQuot(this.getDefault()));
        printWriter.print("\"");
        printWriter.print(" name=\"");
        printWriter.print(URelaxer.escapeAttrQuot(this.getName()));
        printWriter.print("\"");
        if (this.force_ != null) {
            printWriter.print(" force=\"");
            printWriter.print(new Boolean(this.getForce()).toString());
            printWriter.print("\"");
        }
        printWriter.print(">");
        int n = this.description_.size();
        int n2 = 0;
        while (n2 < n) {
            Description description = (Description)this.description_.get(n2);
            description.makeTextElement(printWriter);
            ++n2;
        }
        printWriter.print("</option>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "option")) {
            return false;
        }
        RStack rStack = new RStack(element);
        while (!rStack.isEmptyElement()) {
            if (!Description.isMatchHungry(rStack)) break;
        }
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return Option.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (Option.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

