/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.relaxer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.SwingUtil;
import jp.gr.java_conf.ccs2.io.EasyWriter;
import jp.gr.java_conf.ccs2.tool.mkrelax.MainApp;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.Description;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.Option;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.RelaxerOptions;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.Switch;
import jp.gr.java_conf.ccs2.util.ExtensionFileFilter;
import jp.gr.java_conf.ccs2.util.ResourceFile;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class RelaxerDialog
extends JFrame {
    private static final String TITLE_HINT = "{0} ({1})";
    private String relaxPath;
    private SwitchEntry[] switches;
    private OptionEntry[] options;
    private Entry[] totalEntries;
    private Locale locale = Locale.getDefault();
    private JTextArea outputArea;
    private JTextField pathField;
    private JButton execButton;
    private JButton cancelButton;
    private boolean show = false;
    private Process process;
    private ResourceFile currentResource;
    private boolean stdReady = false;
    private boolean errReady = false;

    public RelaxerDialog(String string) {
        super(MainApp.getResString("Relaxer.DialogTitle"));
        this.relaxPath = string;
        this.setupRelaxerResource();
        this.setupGui();
        SwingUtil.setCenter(this);
    }

    public boolean isShown() {
        return this.show;
    }

    public void setPath(String string) {
        this.relaxPath = string;
    }

    public void show() {
        this.show = true;
        super.show();
    }

    public void dispose() {
        this.show = false;
        super.dispose();
    }

    private void loadCurrentResource() {
        File file = new File(new File(this.relaxPath).getParent(), "Relaxer.properties");
        if (file.exists()) {
            this.currentResource = ResourceFile.getResourceFile(file.getPath());
        }
    }

    private void setupRelaxerResource() {
        this.loadCurrentResource();
        URL uRL = "".getClass().getResource("/jp/gr/java_conf/ccs2/tool/mkrelax/relaxer/relaxerOptions.xml");
        RelaxerOptions relaxerOptions = null;
        try {
            relaxerOptions = new RelaxerOptions(uRL);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{exception.getMessage(), exception.getClass().getName()};
            String string = MessageFormat.format(MainApp.getResString("InternalError{0}{1}"), objectArray);
            MainApp.getAppContext().getMonitor().recordStackTrace(exception);
            throw new InternalError(string);
        }
        this.totalEntries = new Entry[relaxerOptions.getSwitchCount() + relaxerOptions.getOptionCount()];
        Switch[] switchArray = relaxerOptions.getSwitch();
        this.switches = new SwitchEntry[switchArray.length];
        int n = 0;
        while (n < switchArray.length) {
            this.switches[n] = new SwitchEntry(switchArray[n].getName(), switchArray[n].getDefault(), this.getDescription(switchArray[n].getDescription()), switchArray[n].checkForce() && switchArray[n].getForce());
            this.totalEntries[n] = this.switches[n];
            ++n;
        }
        Option[] optionArray = relaxerOptions.getOption();
        this.options = new OptionEntry[optionArray.length];
        int n2 = 0;
        while (n2 < optionArray.length) {
            this.options[n2] = new OptionEntry(optionArray[n2].getName(), optionArray[n2].getDefault(), this.getDescription(optionArray[n2].getDescription()), optionArray[n2].checkForce() && optionArray[n2].getForce());
            this.totalEntries[n2 + this.switches.length] = this.options[n2];
            ++n2;
        }
    }

    private String getCurrentOption(String string) {
        if (this.currentResource == null) {
            return null;
        }
        try {
            return this.currentResource.getString(string);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private String getDescription(Description[] descriptionArray) {
        if (descriptionArray == null || descriptionArray.length == 0) {
            return MainApp.getResString("Relaxer.NoDescription");
        }
        String string = MainApp.getResString("Relaxer.NoDescription");
        String string2 = null;
        int n = 0;
        while (n < descriptionArray.length) {
            if (StringUtil.isNull(descriptionArray[n].getLang())) {
                string = descriptionArray[n].getContent();
            } else if (this.locale.getLanguage().equals(new Locale(descriptionArray[n].getLang(), "", "").getLanguage())) {
                string2 = descriptionArray[n].getContent();
            }
            ++n;
        }
        return StringUtil.isNull(string2) ? string : string2;
    }

    private void setupGui() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add(MainApp.getResString("Relaxer.optionsTabTitle"), this.initOptionsPane());
        jTabbedPane.add(MainApp.getResString("Relaxer.switchesTabTitle"), this.initSwitchesPane());
        jTabbedPane.add(MainApp.getResString("Relaxer.execTabTitle"), this.initRelaxerPane());
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.initExitButton(), "South");
        ((Component)this).setSize(550, 500);
    }

    private JPanel initExitButton() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(MainApp.getResString("Relaxer.exitButtonTitle"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelaxerDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(MainApp.getResString("Relaxer.resetAllButtonTitle"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelaxerDialog.this.resetAllOptions();
            }
        });
        jPanel.add(jButton2);
        return jPanel;
    }

    private void resetAllOptions() {
        int n = 0;
        while (n < this.options.length) {
            this.options[n].reset();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.switches.length) {
            this.switches[n2].reset();
            ++n2;
        }
    }

    private String formatTitle(String string, String string2) {
        return MessageFormat.format(TITLE_HINT, string, string2);
    }

    private JComponent initOptionsPane() {
        JPanel jPanel = new JPanel(new GridLayout(this.options.length, 1));
        int n = 0;
        while (n < this.options.length) {
            final int n2 = n;
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder(this.formatTitle(this.options[n].getName(), this.options[n].getDescription())));
            JTextField jTextField = (JTextField)this.options[n].getComponent();
            jPanel2.add(jTextField);
            JButton jButton = new JButton(MainApp.getResString("Relaxer.resetButtonTitle"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RelaxerDialog.this.options[n2].reset();
                }
            });
            jPanel2.add(jButton);
            this.options[n].setComponent(jTextField);
            jPanel.add(jPanel2);
            ++n;
        }
        return new JScrollPane(jPanel);
    }

    private JComponent initSwitchesPane() {
        JPanel jPanel = new JPanel(new GridLayout(this.switches.length / 2, 2));
        int n = 0;
        while (n < this.switches.length) {
            final int n2 = n;
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder(this.formatTitle(this.switches[n].getName(), this.switches[n].getDescription())));
            JCheckBox jCheckBox = (JCheckBox)this.switches[n].getComponent();
            jPanel2.add(jCheckBox);
            JButton jButton = new JButton(MainApp.getResString("Relaxer.resetButtonTitle"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RelaxerDialog.this.switches[n2].reset();
                }
            });
            jPanel2.add(jButton);
            this.switches[n].setComponent(jCheckBox);
            jPanel.add(jPanel2);
            ++n;
        }
        return new JScrollPane(jPanel);
    }

    private JComponent initRelaxerPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.initRelaxerPaneTopPanel(), "North");
        jPanel.add((Component)this.initRelaxerPaneBottomPanel(), "Center");
        return jPanel;
    }

    private JComponent initRelaxerPaneTopPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(MainApp.getResString("Relaxer.execRelaxerTitle")));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(MainApp.getResString("Relaxer.path")));
        this.pathField = new JTextField(24);
        this.pathField.setText(this.getRelaxerPath());
        jPanel2.add(this.pathField);
        JButton jButton = new JButton(MainApp.getResString("Relaxer.selectPathButtonTitle"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser("/");
                int n = jFileChooser.showOpenDialog(RelaxerDialog.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getPath();
                    RelaxerDialog.this.pathField.setText(string);
                }
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel();
        JButton jButton2 = new JButton(MainApp.getResString("Relaxer.generateButtonTitle"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelaxerDialog.this.generatePropertyFile();
            }
        });
        this.execButton = new JButton(MainApp.getResString("Relaxer.execButtonTitle"));
        this.execButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelaxerDialog.this.execRelaxer();
            }
        });
        this.cancelButton = new JButton(MainApp.getResString("Relaxer.cancelButtonTitle"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RelaxerDialog.this.cancelRelaxer();
            }
        });
        this.cancelButton.setEnabled(false);
        jPanel2.add(jButton2);
        jPanel2.add(this.execButton);
        jPanel2.add(this.cancelButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private String getRelaxerPath() {
        String string = MainApp.getAppContext().getConfig().getOptionString("relaxerPath");
        if (System.getProperty("file.separator").equals("\\")) {
            if (string.indexOf(".bat") == -1) {
                string = string + ".bat";
            }
            if (string.indexOf(":") == -1) {
                string = "c:" + string;
            }
        }
        return string;
    }

    private JComponent initRelaxerPaneBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(MainApp.getResString("Relaxer.outputPanelTitle")));
        this.outputArea = new JTextArea(8, 40);
        jPanel.add(new JScrollPane(this.outputArea));
        return jPanel;
    }

    private void generatePropertyFile() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setSelectedFile(new File("Relaxer.properties"));
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(".properties");
        extensionFileFilter.setDescription(MainApp.getResString("Relaxer.propertiesDescription"));
        jFileChooser.setFileFilter(extensionFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = file.getPath();
        EasyWriter easyWriter = new EasyWriter(string);
        if (!easyWriter.isOk()) {
            JOptionPane.showMessageDialog(this, MainApp.getResString("IOError{0}", string), MainApp.getResString("ErrorDialog"), 0);
            return;
        }
        int n2 = 0;
        while (n2 < this.totalEntries.length) {
            String string2 = this.totalEntries[n2].propertyExpression();
            if (!StringUtil.isNull(string2)) {
                easyWriter.println(string2);
            }
            ++n2;
        }
        easyWriter.flush();
        easyWriter.close();
    }

    private String[] setupArguments() {
        String[] stringArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.pathField.getText());
        int n = 0;
        while (n < this.totalEntries.length) {
            stringArray = this.totalEntries[n].consoleExpression();
            if (!StringUtil.isNull((String)stringArray)) {
                arrayList.add(stringArray);
            }
            ++n;
        }
        arrayList.add(this.relaxPath);
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.append(stringArray[n2]).append(" ");
            ++n2;
        }
        this.appendEvent(stringBuffer.toString());
        MainApp.getAppContext().getMonitor().debug("RELAXER_ARG:" + stringBuffer.toString());
        return stringArray;
    }

    private void execRelaxer() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                RelaxerDialog.this.runRelaxer();
            }
        });
        thread.start();
    }

    private void runRelaxer() {
        block6: {
            try {
                try {
                    this.execButton.setEnabled(false);
                    this.cancelButton.setEnabled(true);
                    this.process = Runtime.getRuntime().exec(this.setupArguments());
                    this.stdReady = true;
                    this.errReady = true;
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            RelaxerDialog.this.readStdout(new BufferedReader(new InputStreamReader(RelaxerDialog.this.process.getInputStream())));
                        }
                    });
                    thread.start();
                    Thread thread2 = new Thread(new Runnable(){

                        public void run() {
                            RelaxerDialog.this.readStderr(new BufferedReader(new InputStreamReader(RelaxerDialog.this.process.getErrorStream())));
                        }
                    });
                    thread2.start();
                    while (this.stdReady || this.errReady) {
                        Thread.sleep(600L);
                        MainApp.getAppContext().getMonitor().debug("RELAXER_OUT:(loop) " + this.stdReady + ":" + this.errReady);
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, MainApp.getResString("Relaxer.IOException{0}", iOException.getMessage()), MainApp.getResString("ErrorDialog"), 0);
                    MainApp.getAppContext().getMonitor().warning(MainApp.getResString("Relaxer.IOException{0}", iOException.getMessage()));
                    Object var4_6 = null;
                    this.stdReady = false;
                    this.errReady = false;
                    this.execButton.setEnabled(true);
                    this.cancelButton.setEnabled(false);
                    this.process = null;
                    this.appendEvent("\n" + MainApp.getResString("Relaxer.processFinished"));
                    break block6;
                }
                catch (InterruptedException interruptedException) {
                    MainApp.getAppContext().getMonitor().recordStackTrace(interruptedException);
                    Object var4_7 = null;
                    this.stdReady = false;
                    this.errReady = false;
                    this.execButton.setEnabled(true);
                    this.cancelButton.setEnabled(false);
                    this.process = null;
                    this.appendEvent("\n" + MainApp.getResString("Relaxer.processFinished"));
                }
                Object var4_5 = null;
                this.stdReady = false;
                this.errReady = false;
                this.execButton.setEnabled(true);
                this.cancelButton.setEnabled(false);
                this.process = null;
                this.appendEvent("\n" + MainApp.getResString("Relaxer.processFinished"));
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.stdReady = false;
                this.errReady = false;
                this.execButton.setEnabled(true);
                this.cancelButton.setEnabled(false);
                this.process = null;
                this.appendEvent("\n" + MainApp.getResString("Relaxer.processFinished"));
                throw throwable;
            }
        }
    }

    private void readStdout(BufferedReader bufferedReader) {
        try {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    MainApp.getAppContext().getMonitor().debug("RELAXER_OUTPUT:" + string);
                    this.appendEvent(string);
                }
                Object var6_4 = null;
                this.stdReady = false;
            }
            catch (IOException iOException) {
                final IOException iOException2 = iOException;
                Runnable runnable = new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(RelaxerDialog.this, MainApp.getResString("Relaxer.IOException{0}", iOException2.getMessage()), MainApp.getResString("ErrorDialog"), 0);
                    }
                };
                SwingUtilities.invokeLater(runnable);
                MainApp.getAppContext().getMonitor().warning(MainApp.getResString("Relaxer.IOException{0}", iOException.getMessage()));
                Object var6_5 = null;
                this.stdReady = false;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.stdReady = false;
            throw throwable;
        }
    }

    private void readStderr(BufferedReader bufferedReader) {
        try {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    MainApp.getAppContext().getMonitor().debug("RELAXER_OUTPUT:(err)" + string);
                    this.appendEvent(string);
                }
                Object var4_4 = null;
                this.errReady = false;
            }
            catch (IOException iOException) {
                MainApp.getAppContext().getMonitor().warning(MainApp.getResString("Relaxer.IOException{0}", iOException.getMessage()));
                Object var4_5 = null;
                this.errReady = false;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.errReady = false;
            throw throwable;
        }
    }

    private void cancelRelaxer() {
        this.process.destroy();
    }

    private void appendEvent(String string) {
        final String string2 = string;
        Runnable runnable = new Runnable(){

            public void run() {
                RelaxerDialog.this.outputArea.append(string2);
                RelaxerDialog.this.outputArea.append("\n");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    class OptionEntry
    extends Entry {
        String name;
        String defaultContent;
        String curContent;

        OptionEntry(String string, String string2, String string3, boolean bl) {
            super(string, string3, new JTextField(30), bl);
            this.defaultContent = string2;
            this.setContent(this.defaultContent);
            if (RelaxerDialog.this.getCurrentOption(string) != null) {
                this.setContent(RelaxerDialog.this.getCurrentOption(string));
            }
        }

        void reset() {
            this.setContent(this.defaultContent);
        }

        String getContent() {
            return ((JTextField)this.component).getText();
        }

        void setContent(String string) {
            ((JTextField)this.component).setText(string);
        }

        boolean isSame() {
            return this.defaultContent.equals(this.getContent());
        }

        String consoleExpression() {
            if (this.isSame() && !this.isForced()) {
                return null;
            }
            return "-" + this.getName() + ":" + this.getContent();
        }

        String propertyExpression() {
            if (this.isSame() && !this.isForced()) {
                return null;
            }
            return this.getName() + "=" + this.getContent();
        }
    }

    class SwitchEntry
    extends Entry {
        boolean defaultState;

        SwitchEntry(String string, boolean bl, String string2, boolean bl2) {
            super(string, string2, new JCheckBox(), bl2);
            this.defaultState = bl;
            this.setState(bl);
            if (RelaxerDialog.this.getCurrentOption(string) != null) {
                if (RelaxerDialog.this.getCurrentOption(string).equals("true")) {
                    this.setState(true);
                } else {
                    this.setState(false);
                }
            }
        }

        void reset() {
            this.setState(this.defaultState);
        }

        boolean getState() {
            return ((JCheckBox)this.component).isSelected();
        }

        void setState(boolean bl) {
            ((JCheckBox)this.component).setSelected(bl);
        }

        boolean isSame() {
            return this.getState() == this.defaultState;
        }

        String consoleExpression() {
            if (this.isForced() && this.getState()) {
                return "-" + this.getName();
            }
            if (this.isSame() || !this.getState()) {
                return null;
            }
            return "-" + this.getName();
        }

        String propertyExpression() {
            if (this.isSame() && !this.isForced()) {
                return null;
            }
            return this.getName() + "=" + (this.getState() ? "true" : "false");
        }
    }

    abstract class Entry {
        String name;
        String description;
        JComponent component;
        boolean force = false;

        Entry(String string, String string2, JComponent jComponent, boolean bl) {
            this.name = string;
            this.description = string2;
            this.component = jComponent;
            this.force = bl;
        }

        String getName() {
            return this.name;
        }

        String getDescription() {
            return this.description;
        }

        void setComponent(JComponent jComponent) {
            this.component = jComponent;
        }

        JComponent getComponent() {
            return this.component;
        }

        boolean isForced() {
            return this.force;
        }

        abstract void reset();

        abstract boolean isSame();

        abstract String consoleExpression();

        abstract String propertyExpression();
    }
}

