/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.tool.mkrelax.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.Option;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.RStack;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.Switch;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.UJAXP;
import jp.gr.java_conf.ccs2.tool.mkrelax.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RelaxerOptions
implements Serializable {
    private List switch_ = new ArrayList();
    private List option_ = new ArrayList();

    public RelaxerOptions() {
    }

    public RelaxerOptions(RStack rStack) {
        this.setup(rStack);
    }

    public RelaxerOptions(Document document) {
        this.setup(document.getDocumentElement());
    }

    public RelaxerOptions(Element element) {
        this.setup(element);
    }

    public RelaxerOptions(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public RelaxerOptions(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public RelaxerOptions(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public RelaxerOptions(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public RelaxerOptions(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public RelaxerOptions(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.setup(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.switch_.clear();
        while (!rStack.isEmptyElement()) {
            if (!Switch.isMatch(rStack)) break;
            this.addSwitch(new Switch(rStack));
        }
        this.option_.clear();
        while (!rStack.isEmptyElement()) {
            if (!Option.isMatch(rStack)) break;
            this.addOption(new Option(rStack));
        }
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("relaxerOptions");
        int n = this.switch_.size();
        int n2 = 0;
        while (n2 < n) {
            Switch switch_ = (Switch)this.switch_.get(n2);
            switch_.makeElement(element);
            ++n2;
        }
        n = this.option_.size();
        int n3 = 0;
        while (n3 < n) {
            Option option = (Option)this.option_.get(n3);
            option.makeElement(element);
            ++n3;
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 1));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 1));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 1));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 1));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 1));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final Switch[] getSwitch() {
        Switch[] switchArray = new Switch[this.switch_.size()];
        return this.switch_.toArray(switchArray);
    }

    public final void setSwitch(Switch[] switchArray) {
        this.switch_.clear();
        this.switch_.addAll(Arrays.asList(switchArray));
    }

    public final void setSwitch(Switch switch_) {
        this.switch_.clear();
        this.switch_.add(switch_);
    }

    public final void addSwitch(Switch switch_) {
        this.switch_.add(switch_);
    }

    public final int getSwitchCount() {
        return this.switch_.size();
    }

    public final Switch getSwitch(int n) {
        return (Switch)this.switch_.get(n);
    }

    public final void setSwitch(int n, Switch switch_) {
        this.switch_.set(n, switch_);
    }

    public final Option[] getOption() {
        Option[] optionArray = new Option[this.option_.size()];
        return this.option_.toArray(optionArray);
    }

    public final void setOption(Option[] optionArray) {
        this.option_.clear();
        this.option_.addAll(Arrays.asList(optionArray));
    }

    public final void setOption(Option option) {
        this.option_.clear();
        this.option_.add(option);
    }

    public final void addOption(Option option) {
        this.option_.add(option);
    }

    public final int getOptionCount() {
        return this.option_.size();
    }

    public final Option getOption(int n) {
        return (Option)this.option_.get(n);
    }

    public final void setOption(int n, Option option) {
        this.option_.set(n, option);
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<relaxerOptions");
        stringBuffer.append(">");
        int n = this.switch_.size();
        int n2 = 0;
        while (n2 < n) {
            Switch switch_ = (Switch)this.switch_.get(n2);
            switch_.makeTextElement(stringBuffer);
            ++n2;
        }
        n = this.option_.size();
        int n3 = 0;
        while (n3 < n) {
            Option option = (Option)this.option_.get(n3);
            option.makeTextElement(stringBuffer);
            ++n3;
        }
        stringBuffer.append("</relaxerOptions>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<relaxerOptions");
        printWriter.print(">");
        int n = this.switch_.size();
        int n2 = 0;
        while (n2 < n) {
            Switch switch_ = (Switch)this.switch_.get(n2);
            switch_.makeTextElement(printWriter);
            ++n2;
        }
        n = this.option_.size();
        int n3 = 0;
        while (n3 < n) {
            Option option = (Option)this.option_.get(n3);
            option.makeTextElement(printWriter);
            ++n3;
        }
        printWriter.print("</relaxerOptions>");
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "relaxerOptions")) {
            return false;
        }
        RStack rStack = new RStack(element);
        while (!rStack.isEmptyElement()) {
            if (!Switch.isMatchHungry(rStack)) break;
        }
        while (!rStack.isEmptyElement()) {
            if (!Option.isMatchHungry(rStack)) break;
        }
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return RelaxerOptions.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (RelaxerOptions.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

