/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import java.util.Enumeration;
import jp.gr.java_conf.ccs2.util.BTreeNode;
import jp.gr.java_conf.ccs2.util.Comparable;
import jp.gr.java_conf.ccs2.util.GenericContainer;
import jp.gr.java_conf.ccs2.util.SimpleEnumeration;
import jp.gr.java_conf.ccs2.util.TreeStructure;

public class BTree
implements GenericContainer,
TreeStructure {
    BTreeNode root = BTreeNode.TERM;
    int count = 0;
    Object[] array;

    public final void addElement(Comparable comparable) {
        BTreeNode bTreeNode = new BTreeNode(comparable);
        if (this.root == BTreeNode.TERM) {
            this.root = bTreeNode;
        } else {
            this.root.set(bTreeNode);
        }
        ++this.count;
    }

    public final void removeElement(Comparable comparable) {
        if (this.root == BTreeNode.TERM) {
            return;
        }
        BTreeNode bTreeNode = new BTreeNode(comparable);
        BTreeNode bTreeNode2 = this.root.remove(bTreeNode);
        if (bTreeNode2 == null) {
            --this.count;
            return;
        }
        if (bTreeNode2 == bTreeNode) {
            System.err.println("cannot remove element.(BT)");
            return;
        }
        this.root = bTreeNode2;
        --this.count;
    }

    public final void removeAllElements() {
        this.root.dispose();
        this.root = BTreeNode.TERM;
        this.count = 0;
    }

    public final boolean contains(Comparable comparable) {
        return this.root.search(comparable);
    }

    public final Comparable getSameValue(Comparable comparable) {
        return this.root.searchOf(comparable);
    }

    public final void update() {
        if (this.root == BTreeNode.TERM) {
            return;
        }
        this.root = BTreeNode.TERM;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            this.addElement((Comparable)enumeration.nextElement());
        }
    }

    public final Enumeration elements() {
        if (this.root == BTreeNode.TERM) {
            return null;
        }
        if (this.array == null || this.array.length < this.size()) {
            this.array = new Object[this.size()];
        }
        this.root.browse(this.array, 0);
        return new SimpleEnumeration(this.array, this.size());
    }

    public final Comparable firstElement() {
        if (this.root == BTreeNode.TERM) {
            return null;
        }
        BTreeNode bTreeNode = this.root;
        BTreeNode bTreeNode2 = null;
        while (bTreeNode != BTreeNode.TERM) {
            bTreeNode2 = bTreeNode;
            bTreeNode = bTreeNode.lessChild;
        }
        return bTreeNode2.object;
    }

    public final Comparable lastElement() {
        if (this.root == BTreeNode.TERM) {
            return null;
        }
        BTreeNode bTreeNode = this.root;
        BTreeNode bTreeNode2 = null;
        while (bTreeNode != BTreeNode.TERM) {
            bTreeNode2 = bTreeNode;
            bTreeNode = bTreeNode.greatChild;
        }
        return bTreeNode2.object;
    }

    public final boolean isEmpty() {
        return this.count <= 0;
    }

    public final int size() {
        return this.count;
    }

    public void _addElement(Object object) {
        this.addElement((Comparable)object);
    }

    public void _removeElement(Object object) {
        this.removeElement((Comparable)object);
    }

    public void _removeAllElements() {
        this.removeAllElements();
    }

    public boolean _isEmpty() {
        return this.isEmpty();
    }

    public Enumeration _elements() {
        return this.elements();
    }

    public int _size() {
        return this.size();
    }

    public boolean _contains(Object object) {
        return this.contains((Comparable)object);
    }

    public String getTreeNodeExpression() {
        return "BTree(" + this.size() + ")";
    }

    public TreeStructure[] getTreeNodes() {
        if (this.size() == 0) {
            return null;
        }
        TreeStructure[] treeStructureArray = new TreeStructure[]{this.root};
        return treeStructureArray;
    }
}

