/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ccs2.util;

import jp.gr.java_conf.ccs2.util.Comparable;
import jp.gr.java_conf.ccs2.util.TreeStructure;

class BTreeNode
implements TreeStructure {
    static BTreeNode TERM = new BTreeNode(null);
    Comparable object;
    BTreeNode greatChild = TERM;
    BTreeNode lessChild = TERM;
    BTreeNode parent;

    public final void setObject(Comparable comparable) {
        this.object = comparable;
    }

    public final Comparable getObject() {
        return this.object;
    }

    BTreeNode(Comparable comparable) {
        this.object = comparable;
    }

    final void set(BTreeNode bTreeNode) {
        if (bTreeNode == null) {
            return;
        }
        if (this.greaterThan(bTreeNode)) {
            this.setGreat(bTreeNode);
        } else {
            this.setLess(bTreeNode);
        }
    }

    private final void setGreat(BTreeNode bTreeNode) {
        if (this.greatChild == TERM) {
            this.greatChild = bTreeNode;
            bTreeNode.parent = this;
        } else {
            this.greatChild.set(bTreeNode);
        }
    }

    private final void setLess(BTreeNode bTreeNode) {
        if (this.lessChild == TERM) {
            this.lessChild = bTreeNode;
            bTreeNode.parent = this;
        } else {
            this.lessChild.set(bTreeNode);
        }
    }

    final boolean search(Comparable comparable) {
        if (comparable == this.object) {
            return true;
        }
        if (this.object.greaterThan(comparable)) {
            if (this.greatChild != TERM) {
                return this.greatChild.search(comparable);
            }
            return false;
        }
        if (this.lessChild != TERM) {
            return this.lessChild.search(comparable);
        }
        return false;
    }

    final Comparable searchOf(Comparable comparable) {
        if (this.object.equals(comparable)) {
            return this.object;
        }
        if (this.object.greaterThan(comparable)) {
            if (this.greatChild != TERM) {
                return this.greatChild.searchOf(comparable);
            }
            return null;
        }
        if (this.lessChild != TERM) {
            return this.lessChild.searchOf(comparable);
        }
        return null;
    }

    final BTreeNode remove(BTreeNode bTreeNode) {
        if (bTreeNode.getObject() == this.getObject()) {
            if (this.greatChild == TERM && this.lessChild == TERM) {
                return TERM;
            }
            if (this.greatChild == TERM) {
                return this.lessChild;
            }
            if (this.lessChild == TERM) {
                return this.greatChild;
            }
            this.greatChild.set(this.lessChild);
            return this.greatChild;
        }
        if (this.greaterThan(bTreeNode)) {
            if (this.greatChild == TERM) {
                return bTreeNode;
            }
            BTreeNode bTreeNode2 = this.greatChild.remove(bTreeNode);
            if (bTreeNode2 == bTreeNode) {
                return bTreeNode;
            }
            if (bTreeNode2 == null) {
                return null;
            }
            this.greatChild = TERM;
            if (bTreeNode2 != TERM) {
                this.set(bTreeNode2);
            }
            return null;
        }
        if (this.lessChild == TERM) {
            return bTreeNode;
        }
        BTreeNode bTreeNode3 = this.lessChild.remove(bTreeNode);
        if (bTreeNode3 == bTreeNode) {
            return bTreeNode;
        }
        if (bTreeNode3 == null) {
            return null;
        }
        this.lessChild = TERM;
        if (bTreeNode3 != TERM) {
            this.set(bTreeNode3);
        }
        return null;
    }

    final int browse(Object[] objectArray, int n) {
        if (this.lessChild != TERM) {
            n = this.lessChild.browse(objectArray, n);
        }
        objectArray[n] = this.object;
        ++n;
        if (this.greatChild != TERM) {
            n = this.greatChild.browse(objectArray, n);
        }
        return n;
    }

    final void dispose() {
        if (this.lessChild != TERM) {
            this.lessChild.dispose();
            this.lessChild = TERM;
        }
        if (this.greatChild != TERM) {
            this.greatChild.dispose();
            this.greatChild = TERM;
        }
        this.object = null;
        this.parent = null;
    }

    final boolean greaterThan(BTreeNode bTreeNode) {
        return bTreeNode.getObject().greaterThan(this.getObject());
    }

    public String getTreeNodeExpression() {
        if (this == TERM) {
            return "TERM";
        }
        return "Node(" + this.object + ")";
    }

    public TreeStructure[] getTreeNodes() {
        if (this == TERM) {
            return null;
        }
        if (this.lessChild == TERM && this.greatChild == TERM) {
            return null;
        }
        TreeStructure[] treeStructureArray = new TreeStructure[]{this.lessChild, this.greatChild};
        return treeStructureArray;
    }
}

