/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.swift;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jp.co.swiftinc.relax.schema.Grammar;
import jp.co.swiftinc.relax.verifier.NotValidException;
import jp.co.swiftinc.relax.verifier.RELAXErrorHandler;
import jp.co.swiftinc.relax.verifier.RELAXNormalHandler;
import jp.gr.xml.relax.sax.DOMSAXProducer;
import jp.gr.xml.relax.swift.SwiftErrorHandler;
import jp.gr.xml.relax.swift.SwiftVerifierFilter;
import jp.gr.xml.relax.swift.SwiftVerifierHandler;
import org.apache.xerces.parsers.SAXParser;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierException;
import org.iso_relax.verifier.VerifierFilter;
import org.iso_relax.verifier.VerifierHandler;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SwiftVerifier
implements Verifier {
    private Grammar grammar_;
    private XMLReader reader_;
    private ErrorHandler errorHandler_;

    public SwiftVerifier(Grammar grammar) throws VerifierConfigurationException {
        this.grammar_ = grammar;
        this.reader_ = this._getXMLReader();
    }

    private XMLReader _getXMLReader() throws VerifierConfigurationException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            javax.xml.parsers.SAXParser sAXParser = sAXParserFactory.newSAXParser();
            return new SAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new VerifierConfigurationException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new VerifierConfigurationException(sAXException);
        }
    }

    public boolean isFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://www.iso-relax.org/verifier/handler".equals(string) || "http://www.iso-relax.org/verifier/filter".equals(string)) {
            return true;
        }
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler_ = errorHandler;
        this.reader_.setErrorHandler(errorHandler);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.reader_.setEntityResolver(entityResolver);
    }

    public boolean verify(String string) throws SAXException, IOException {
        RELAXNormalHandler rELAXNormalHandler = new RELAXNormalHandler(this.grammar_);
        if (this.errorHandler_ != null) {
            rELAXNormalHandler.setErrorHandler((RELAXErrorHandler)new SwiftErrorHandler(this.errorHandler_));
        }
        this.reader_.setContentHandler((ContentHandler)rELAXNormalHandler);
        try {
            this.reader_.parse(string);
            return true;
        }
        catch (NotValidException notValidException) {
            return false;
        }
        catch (SAXException sAXException) {
            throw new SAXException(sAXException);
        }
    }

    public boolean verify(InputSource inputSource) throws SAXException, IOException {
        RELAXNormalHandler rELAXNormalHandler = new RELAXNormalHandler(this.grammar_);
        this.reader_.setContentHandler((ContentHandler)rELAXNormalHandler);
        try {
            this.reader_.parse(inputSource);
            return true;
        }
        catch (NotValidException notValidException) {
            return false;
        }
        catch (SAXException sAXException) {
            throw new SAXException(sAXException);
        }
    }

    public boolean verify(Node node) throws SAXException {
        DOMSAXProducer dOMSAXProducer = new DOMSAXProducer(node);
        RELAXNormalHandler rELAXNormalHandler = new RELAXNormalHandler(this.grammar_);
        try {
            dOMSAXProducer.makeEvent((ContentHandler)rELAXNormalHandler);
            return true;
        }
        catch (NotValidException notValidException) {
            return false;
        }
        catch (SAXException sAXException) {
            throw new VerifierException(sAXException);
        }
    }

    public VerifierHandler getVerifierHandler() {
        return new SwiftVerifierHandler(this.grammar_);
    }

    public VerifierFilter getVerifierFilter() {
        return new SwiftVerifierFilter(this.grammar_);
    }
}

