/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.swift;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.swiftinc.relax.schema.Grammar;
import jp.co.swiftinc.relax.schema.SchemaLoader;
import jp.co.swiftinc.relax.schema.SchemaSyntaxErrorException;
import jp.gr.xml.relax.sax.RELAXEntityResolver;
import jp.gr.xml.relax.swift.SwiftSchema;
import jp.gr.xml.relax.swift.SwiftVerifier;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierException;
import org.iso_relax.verifier.VerifierFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SwiftVerifierFactory
extends VerifierFactory {
    public boolean isFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException(string);
    }

    public Verifier newVerifier(String string) throws VerifierConfigurationException, SAXException, IOException {
        return new SwiftVerifier(this.loadSchema(string));
    }

    public Verifier newVerifier(InputSource inputSource) throws VerifierConfigurationException, SAXException, IOException {
        return new SwiftVerifier(this.loadSchema(inputSource));
    }

    public Schema compileSchema(InputSource inputSource) throws VerifierConfigurationException, SAXException {
        return new SwiftSchema(this.loadSchema(inputSource));
    }

    public Schema compileSchema(String string) throws VerifierConfigurationException, SAXException, IOException {
        return new SwiftSchema(this.loadSchema(string));
    }

    private DocumentBuilder _getDocumentBuilder() throws VerifierConfigurationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new RELAXEntityResolver());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new VerifierConfigurationException(parserConfigurationException);
        }
    }

    private Grammar loadSchema(String string) throws VerifierConfigurationException, SAXException, IOException {
        try {
            DocumentBuilder documentBuilder = this._getDocumentBuilder();
            Document document = documentBuilder.parse(string);
            return SchemaLoader.load((Document)document, (String)string);
        }
        catch (SchemaSyntaxErrorException schemaSyntaxErrorException) {
            throw new VerifierException((Exception)((Object)schemaSyntaxErrorException));
        }
        catch (SAXException sAXException) {
            throw new VerifierException(sAXException);
        }
    }

    private Grammar loadSchema(InputSource inputSource) throws VerifierConfigurationException, SAXException {
        try {
            DocumentBuilder documentBuilder = this._getDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return SchemaLoader.load((Document)document, (String)inputSource.getSystemId());
        }
        catch (SchemaSyntaxErrorException schemaSyntaxErrorException) {
            throw new VerifierException((Exception)((Object)schemaSyntaxErrorException));
        }
        catch (SAXException sAXException) {
            throw new VerifierException(sAXException);
        }
        catch (IOException iOException) {
            throw new VerifierException(iOException);
        }
    }
}

