/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;
import java.awt.event.*;
import java.util.LinkedList;
import java.util.List;
import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.gr.java_conf.ccs2.core.CCSResource;
import jp.gr.java_conf.ccs2.comp.SwingUtil;

public class SelectionDialog extends JDialog {

    protected List contents;
    protected int index = -1;
    
    public SelectionDialog(Frame f,String title,List t) {
	super (f,true);
	initComponents ();
        contents = t;
        titleLabel.setText(title);
        updateList();
        okButton.setEnabled(false);
        pack();
	SwingUtil.setCenter(this);
    }
    
    private void initComponents () {
	titleLabel = new JLabel ();
	jPanel1 = new JPanel ();
	okButton = new JButton ();
	cancelButton = new JButton ();
	jScrollPane1 = new JScrollPane ();
	list = new JList ();
	addWindowListener (new WindowAdapter () {
		public void windowClosing (WindowEvent evt) {
		    closeDialog (evt);
		}
	    });
	Font tf = titleLabel.getFont();
	titleLabel.setFont ( tf.deriveFont((float)(tf.getSize2D()*1.5)) );

	BorderLayout layout = new BorderLayout();
	layout.setVgap(5);
	layout.setHgap(3);
	getContentPane().setLayout(layout);
	getContentPane().add (titleLabel, BorderLayout.NORTH);
	
	okButton.setText (CCSResource.getResourceString("Ok"));
	okButton.addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent evt) {
		    okButtonActionPerformed (evt);
		}
	    });
	jPanel1.add (okButton);
	
	cancelButton.setText (CCSResource.getResourceString("Cancel"));
	cancelButton.addActionListener (new ActionListener () {
		public void actionPerformed (ActionEvent evt) {
		    cancelButtonActionPerformed (evt);
		}
	    });
	jPanel1.add (cancelButton);
	
	getContentPane ().add (jPanel1, BorderLayout.SOUTH);

	list.setFixedCellWidth (200);
	list.addKeyListener (new KeyAdapter () {
		public void keyTyped (KeyEvent evt) {
		    listKeyTyped (evt);
		}
	    });
	list.addListSelectionListener (new ListSelectionListener () {
		public void valueChanged (ListSelectionEvent evt) {
		    listValueChanged (evt);
		}
	    });
	list.addMouseListener (new MouseAdapter () {
		public void mouseClicked (MouseEvent evt) {
		    listMouseClicked (evt);
		}
	    });
	jScrollPane1.setViewportView (list);
	
	getContentPane().add (jScrollPane1, BorderLayout.CENTER);
    }

    private void listKeyTyped (KeyEvent evt) {
	if (evt.getKeyChar() == '\n')
	    onOk();
    }

    private void listValueChanged (ListSelectionEvent evt) {
	okButton.setEnabled(true);
    }

    private void cancelButtonActionPerformed (ActionEvent evt) {
	dispose();
    }

    private void okButtonActionPerformed (ActionEvent evt) {
	onOk();
    }

    private void listMouseClicked (MouseEvent evt) {
	okButton.setEnabled(true);
	if (evt.getClickCount() == 2) 
	    onOk();
    }


    private void closeDialog(WindowEvent evt) {
	setVisible (false);
	dispose ();
    }

    public static void main (String args[]) {
	List t = new LinkedList();
	t.add("first");
	t.add("second");
	t.add("third");
	SelectionDialog dlg = new SelectionDialog
	    (new JFrame (),"Dialog test",t);
	dlg.show();
	if (dlg.getIndex() != -1) {
	    System.out.println(t.get(dlg.getIndex()));
	} else 
	    System.out.println("canceled");
    }

    void updateList() {
        Object [] array = contents.toArray();
        list.setListData(array);
    }

    public void onOk() {
        int i = list.getSelectedIndex();
        if (i<0 && i>=contents.size()) {
            JOptionPane.showMessageDialog
		(this,CCSResource.getResourceString("Please_select_an_item."));
            return;
        }
        index = i;
        dispose();
    }

    public int getIndex() {return index;}
    
    private JLabel titleLabel;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JList list;

}

