/* CCS, Class Collection by Sakurai
 *	Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.comp;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import jp.gr.java_conf.ccs2.util.BTree;
import jp.gr.java_conf.ccs2.util.Comparable;
import jp.gr.java_conf.ccs2.util.ComparableClass;
import jp.gr.java_conf.ccs2.util.TreeStructure;


/** TreeStructure data viewer implemented by JTree */
public class TreeStructureSwingViewer {

	public TreeStructureSwingViewer(TreeStructure root) {
		setTree(root);
	}

	public void setTree(TreeStructure root) {
		DefaultMutableTreeNode top = translate(root);
		show(top);
	}

	protected DefaultMutableTreeNode translate(TreeStructure root) {
		String name = root.getTreeNodeExpression();
		DefaultMutableTreeNode tn = new DefaultMutableTreeNode(name);
		TreeStructure [] children = root.getTreeNodes();
		if (children != null && children.length > 0) {
			for (int i=0;i<children.length;i++)
				tn.add(translate(children[i]));
		}
		return tn;
	}

	JFrame frame;
	JTree tree;

	protected void show(DefaultMutableTreeNode root) {
		if (frame == null) {
			frame = new JFrame("Tree Viewer");
			frame.setSize(500,600);
			frame.addWindowListener (new WindowAdapter () {
					public void windowClosing (WindowEvent evt) {
						System.exit(0);
					}
				});
		}
		//
		if (tree == null) {
			tree = new JTree(root);
			frame.getContentPane().add(new JScrollPane(tree));
		} else {
			tree.setModel(new DefaultTreeModel(root));
		}
		frame.show();
	}
	
	public static void main(String [] args) {
		BTree tr = new BTree();
		tr.addElement(n(2));//root	 2
		tr.addElement(n(3));//	  1		3
		tr.addElement(n(1));//			   5
		tr.addElement(n(5));//			4	  6
		tr.addElement(n(4));//		   
		tr.addElement(n(6));//			  
		TreeStructureSwingViewer sw = new TreeStructureSwingViewer(tr);
	}

	static Comparable n(double a) {
		final double aa = a;
		return new ComparableClass() {
				double num = aa;
				public double getValue() {return num;}
				public String toString() {return ""+getValue();}
			};
	}

}

