/* CCS, Class Collection by Sakurai
 *  Copyright (C) 2000-2001 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.core;
import java.util.ResourceBundle;
import java.util.MissingResourceException;
import java.util.HashMap;
import java.util.List;
import java.util.LinkedList;
import java.util.Enumeration;
import java.util.Iterator;
import java.io.File;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.util.ResourceFile;

public class AppConfig {

    protected static String separator = ":";
    protected AppContext appContext;

    HashMap table = new HashMap();
    List fileList = new LinkedList();

    public AppConfig(String defaultsUri,String propFile,String [] args) {
	setupDefaults(defaultsUri);
	setupFile(propFile);
	setupArgs(args);
    }

    public AppConfig(String propFile,String [] args) {
	this(null,propFile,args);
    }

    public AppConfig(String [] args) {
	this(null,args);
    }

    public void setAppContext(AppContext app) {
	appContext = app;
    }

    protected void setupDefaults(String prop) {
	try {
	    setupProp(ResourceBundle.getBundle(prop));
	} catch (MissingResourceException e) {
	}
    }

    protected void setupFile(String propFile) {
	File file = new File(propFile);
	if (!file.exists()) return;
	setupProp(ResourceFile.getResourceFile(propFile));
    }

    protected void setupProp(ResourceBundle res) {
	if (res == null) return;
	Enumeration keys = res.getKeys();
	while(keys.hasMoreElements()) {
	    String key = (String)keys.nextElement();
	    try {
		String cont = res.getString(key);
		if (cont.equalsIgnoreCase("true") || 
		    cont.equalsIgnoreCase("yes")) {
		    table.put(key,Boolean.TRUE);
		} else if (cont.equalsIgnoreCase("false") || 
			   cont.equalsIgnoreCase("no")) {
		    table.put(key,Boolean.FALSE);
		} else {
		    table.put(key,cont);
		}
	    } catch (MissingResourceException e) {
	    }
	}
    }

    protected void setupArgs(String [] args) {
	if (args == null || args.length == 0) return;
	for (int i=0;i<args.length;i++) {
	    if (args[i].charAt(0)!='-') {
		fileList.add(args[i]);
		continue;
	    }
	    int ps = args[i].indexOf(separator);
	    if (ps == -1) {
		table.put(args[i].substring(1),Boolean.TRUE);//without content
	    } else {
		table.put(args[i].substring(1,ps),//option name
			  args[i].substring(ps+1));//option content
	    }
	}
    }

    public String getDumpProperties() {
	StringBuffer sb = new StringBuffer();
	Iterator keys = table.keySet().iterator();
	while(keys.hasNext()) {
	    String key = (String)keys.next();
	    String cont = table.get(key).toString();
	    sb.append(key+":"+cont+"\n");
	}
	for (int i=0;i<fileList.size();i++) {
	    sb.append("FILE:"+fileList.get(i));
	}
	return sb.toString();
    }
    
    public boolean getOption(String optionName) {
	Object obj = table.get(optionName);
	if (obj == null || !(obj instanceof Boolean)) return false;
	return ((Boolean)obj)==Boolean.TRUE ? true:false;
    }
    
    public String getOptionString(String optionName) {
	Object obj = table.get(optionName);
	if (obj == null || !(obj instanceof String)) return null;
	return (String)obj;
    }

    public int getOptionInteger(String optionName) {
	String ret = getOptionString(optionName);
	if (StringUtil.isNull(ret)) return -1;
	try {
	    return Integer.parseInt(ret);
	} catch (NumberFormatException e) {
	    if (appContext != null)
		appContext.getMonitor().warning
		    ("property ["+optionName+"] is wrong number.");
	}
	return -1;
    }

    public double getOptionDouble(String optionName) {
	String ret = getOptionString(optionName);
	if (StringUtil.isNull(ret)) return -1;
	try {
	    return Double.parseDouble(ret);
	} catch (NumberFormatException e) {
	    if (appContext != null)
		appContext.getMonitor().warning
		    ("property ["+optionName+"] is wrong number.");
	}
	return -1;
    }

    public String getArgumentFile() {
	if (fileList.size() == 0) return null;
	return (String)fileList.get(0);
    }

    public String [] getArgumentFiles() {
	String [] ret = new String[fileList.size()];
	return (String[])fileList.toArray(ret);
    }

}
