/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;
import java.io.Serializable;


public abstract class AbstractElementModel extends AbstractHedgeModel implements Serializable{

    protected AbstractElementModel(ModuleModel mm) {
	super(mm);
    }

    static final long serialVersionUID = -3655376765587144325L;
    int occurs = OCCURS_ONE;

    public static final int OCCURS_ONE =0;
    public static final int OCCURS_MORE_THAN_ZERO =1;
    public static final int OCCURS_MORE_THAN_ONE =2;
    public static final int OCCURS_ZERO_OR_ONE =3;

    public static final String [] occurSymbols = {
	"","*","+","?"
    };

    public static int getOccursBySymbol(String t) {
	t = t.trim();
	for (int i=0;i<occurSymbols.length;i++) {
	    if (occurSymbols[i].equals(t))
		return i;
	}
	throw new RuntimeException("No such occurs symbol! ["+t+"]");
    }
    public static String getOccurSymbol(int t) {
	if (t<0 || t>=occurSymbols.length) 
	    throw new RuntimeException("Invalid occur id!");
	
	return occurSymbols[t];
    }

    public void setOccurs(int a) { occurs = a; }
    public void setOccurs(String a) {
	setOccurs(getOccursBySymbol(a));
    }
    public int getOccurs() { return occurs; }
    public String getOccurSymbol() {
	return getOccurSymbol(getOccurs());
    }

    protected void copyTo(AbstractElementModel copy) {
	copy.setOccurs(getOccurs());
    }
}


