/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;

public abstract class AbstractMultiElementModel extends AbstractElementModel {

    static final long serialVersionUID = 5482962339092314034L;

    List elements = new ArrayList();

    protected AbstractMultiElementModel(ModuleModel mm) {
	super(mm);
    }

    public void addElement(AbstractHedgeModel em) {
	if (em == null) return;
	elements.add(em);
    }

    public void removeElement(AbstractHedgeModel em) {
	if (em == null) return;
	elements.remove(em);
    }

    public AbstractHedgeModel  []  getElements() {
        AbstractHedgeModel [] ar = new AbstractHedgeModel[elements.size()];
        return (AbstractHedgeModel[]) elements.toArray(ar);
    }

    public AbstractHedgeModel getElement(int i) {
	return (AbstractHedgeModel)elements.get(i);
    }

    public int getElementNum() {
	return elements.size();
    }

    public boolean canMoveElementUpward(ElementOperation obj) {
	int ps = elements.indexOf(obj);
	if (ps < 0) {
	    if (obj instanceof ObjectModel) {
		return canMoveElementUpward( getCorrespondRef((ObjectModel)obj) );
	    }
	    return false;
	}
	if (ps > 0) return true;
	return false;
    }

    public void moveElementUpward(ElementOperation obj) {
	if (!canMoveElementUpward(obj))
	    throw new InternalError("Forbidden operation.");

	ElementOperation ref=obj;
	int ps = elements.indexOf(obj);
	if (ps == -1) {
	    if (obj instanceof ObjectModel) {
		ref = getCorrespondRef((ObjectModel)obj);
		ps = elements.indexOf( ref );
	    }
	    if (ps == -1) throw new InternalError("Unexpected error.");
	}
	elements.remove(ref);
	elements.add(ps-1,ref);
    }

    public boolean canMoveElementDownward(ElementOperation obj) {
	int ps = elements.indexOf(obj);
	if (ps < 0) {
	    if (obj instanceof ObjectModel) {
		return canMoveElementDownward( getCorrespondRef((ObjectModel)obj) );
	    }
	    return false;
	}
	if (ps < (elements.size()-1)) return true;
	return false;
    }

    public void moveElementDownward(ElementOperation obj) {
	if (!canMoveElementDownward(obj))
	    throw new InternalError("Forbidden operation.");

	ElementOperation ref=obj;
	int ps = elements.indexOf(obj);
	if (ps == -1) {
	    if (obj instanceof ObjectModel) {
		ref = getCorrespondRef((ObjectModel)obj);
		ps = elements.indexOf( ref );
	    }
	    if (ps == -1) throw new InternalError("Unexpected error.");
	}
	elements.remove(ref);
	elements.add(ps+1,ref);
    }


    // ElementOperation stuff

    public boolean canAddElement() {return true;}
    public void addOpElements(ElementOperation [] args) {
	if (args == null || args.length==0) return;
	for (int i=0;i<args.length;i++) {
	    if (args[i] instanceof AbstractHedgeModel) {
		if (args[i].getOpElementLevel() == HEDGE) {
		    addElement((AbstractHedgeModel)args[i]);
		} else {
		throw new InternalError("Object is now the subclass of AbstractHedgeModel.(bug)");
		}
	    } else if (args[i] instanceof ObjectModel) {
		addElement(ElementUtil.getRef(getParentModule(),
					      (ObjectModel)args[i]));
	    } else {
		throw new InternalError("Forbidden operation.(bug)");
	    }
	}
    }
    public ElementOperation [] getOpElements() {
	if (elements.size()==0) return null;
        ElementOperation [] ar = new ElementOperation[elements.size()];
        return (ElementOperation[]) elements.toArray(ar);
    }
    public void removeOpElement(ElementOperation arg) {
	if (arg instanceof AbstractHedgeModel) {
	    if (elements.contains(arg)) {
		removeElement((AbstractHedgeModel)arg);
		return;
	    }
	}
	if (arg instanceof ObjectModel) {
	    RefElementModel ref = getCorrespondRef((ObjectModel)arg);
	    if (ref != null) {
		removeElement(ref);
		return;
	    }
	}
	throw new InternalError("No such element.(bug) : "+arg.getClass().getName()+" : "+elements);
    }
    private RefElementModel getCorrespondRef(ObjectModel obj) {
	ElementOperation [] ar = getOpElements();
	if (ar == null) return null;
	for (int i=0;i<ar.length;i++) {
	    if (ar[i] instanceof RefElementModel) {
		RefElementModel ref = (RefElementModel)ar[i];
		if (ref.getAt() == obj)
		    return ref;
	    }
	}
	return null;
    }

    public boolean acceptOpElement(ElementOperation e) {
	if (e.getOpElementLevel() == HEDGE ||
	    e.getOpElementLevel() == OBJECT) {
	    return true;
	}
	return false;
    }

    protected ElementOperation getOpChildrenCopy(AbstractMultiElementModel ret) {
	ElementOperation [] children = getOpElements();
	if (children == null) return ret;
	ElementOperation [] cpc = new ElementOperation[children.length];
	for (int i=0;i<cpc.length;i++) {
	    cpc[i] = children[i].getOpCopy();
	}
	ret.addOpElements(cpc);
	copyTo(ret);
	return ret;
    }
}


