/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;
import java.io.Serializable;

public class AttributePoolModel implements Serializable,AttributeOperation {
    static final long serialVersionUID = -2284069146860050497L;

    List attList = new ArrayList();

    String role,comment ;

    public AttributePoolModel() {
    }

    public AttributePoolModel(String r) {
	setRole(r);
    }

    public void setRole(String a) { role = a; }
    public String getRole() { return role; }
    public void setComment(String a) { comment = a; }
    public String getComment() { return comment; }

    public void addAttribute(AttributeModel em) {
	if (em == null) return;
	attList.add(em);
    }

    public void removeAttribute(AttributeModel em) {
	if (em == null) return;
	attList.remove(em);
    }

    public AttributeModel  []  getAttributes() {
        AttributeModel [] ar = new AttributeModel[attList.size()];
        return (AttributeModel[]) attList.toArray(ar);
    }

    public int getAttributeNum() {
	return attList.size();
    }

}


