/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;
import java.io.ObjectInputStream;
import java.io.IOException;


public class ConcreteAttributeModel extends AttributeModel{
    static final long serialVersionUID = 1351507144110851913L;

    DataType type = DataType.DEFAULT_TYPE;
    boolean required =false;
    String name,comment;

    public ConcreteAttributeModel(String n,DataType t,boolean b) {
	setType(t);
	setName(n);
	setRequired(b);
    }

    public ConcreteAttributeModel(String n,String typeString,boolean b) {
	setType(typeString);
	setName(n);
	setRequired(b);
    }

    public void setType(DataType a) { type = a; }
    public void setType(String a) {
	setType(DataType.getTypeByName(a));
    }
    public DataType getType() { return type; }

    public void setRequired(boolean a) { required = a; }
    public boolean isRequired() { return required; }

    public void setName(String a) { name = a; }
    public String getName() { return name; }

    public void setComment(String a) { comment = a; }
    public String getComment() { return comment; }

    public AttributeModel getCopy() {
	ConcreteAttributeModel ret = 
	    new ConcreteAttributeModel(getName(),getType(),isRequired());
	ret.setComment(getComment());
	return ret;
    }

    private void readObject(ObjectInputStream s) throws IOException,ClassNotFoundException  {
	s.defaultReadObject();
	setType(type.getTypeName());
    }

}

