/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import jp.gr.java_conf.ccs2.tool.mkrelax.datatype.*;


public class DataType implements Serializable{

    static final long serialVersionUID = 3704269819001334267L;

    public static DataType RLX_ELEMENT;
    public static DataType DEFAULT_TYPE;
    public static DataType [] dataTypes;

    static {
	RLX_ELEMENT = new DataType(MainApp.getResString("(hedgeElement)"));
	URL url = RLX_ELEMENT.getClass().getResource("/jp/gr/java_conf/ccs2/tool/mkrelax/datatype/datatypes.xml");
	Datatypes datatypes = null;
	try {
	    datatypes = new Datatypes(url);
	} catch (SAXException e) {
	    String [] args = {e.getMessage(),e.getClass().getName()};
	    String ret = MessageFormat.format(MainApp.getResString("InternalError{0}{1}"),args);
	    throw new InternalError(ret);
	} catch (ParserConfigurationException e) {
	    String [] args = {e.getMessage(),e.getClass().getName()};
	    String ret = MessageFormat.format(MainApp.getResString("InternalError{0}{1}"),args);
	    throw new InternalError(ret);
	} catch (IOException e) {
	    String [] args = {e.getMessage(),e.getClass().getName()};
	    String ret = MessageFormat.format(MainApp.getResString("InternalError{0}{1}"),args);
	    throw new InternalError(ret);
	}
	String [] entries = datatypes.getEntries().getEntry();
	String def = datatypes.getDefaultType();
	dataTypes = new DataType[entries.length+1];
	dataTypes[0] = RLX_ELEMENT;
	for (int i=0;i<entries.length;i++) {
	    dataTypes[i+1] = new DataType(entries[i]);
	    if (def.equals(entries[i])) {
		DEFAULT_TYPE = dataTypes[i+1];
	    }
	}
    }

    private String typeName;
    private List facets = new ArrayList();

    private DataType() {}
    private DataType(String a) {typeName = a;}
    public String getTypeName() {
	return typeName;
    }
    public boolean equals(DataType e) {
	if (e == null) return false;
	return typeName.equals(e.getTypeName());
    }

    /* under construction
    public void addFacet(FacetModel m) {
    
    }

    public void removeFacet(FacetModel m) {

    }

    public FacetModel [] getFacets() {

    }

    public boolean canAddFacet(FacetModel m) {

    } */

    public String toString() {
	return getTypeName();
    }

    public static DataType getTypeByName(String t) {
	t = t.trim();
	for (int i=0;i<dataTypes.length;i++) {
	    if (dataTypes[i].getTypeName().equals(t)) {
		return dataTypes[i];
	    }
	}
	throw new RuntimeException("No such data type! ["+t+"]");
    }

}


