/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.util.List;
import java.util.ArrayList;

public class ElementCollectVisitor extends VisitorClass {

    public ElementCollectVisitor() {
    }

    /**
       @param f if true, this visitor collects exportable elements.
     */
    public ElementCollectVisitor(boolean f) {
	exportable = f;
    }

    boolean exportable = false;
    List elementList = new ArrayList();

    public ObjectModel [] getElements() {
	ObjectModel [] os = new ObjectModel[elementList.size()];
	return (ObjectModel[])elementList.toArray(os);
    }

    public void objectEnter(ObjectModel obj){
	if (!elementList.contains(obj) ) {
	    if (exportable) {
		if (obj.isExportable()) {
		    elementList.add(obj);
		}
		return;
	    }
	    elementList.add(obj);
	}
    }

}


