/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;

public interface ElementOperation {

    public void addOpElements(ElementOperation [] args);
    public ElementOperation [] getOpElements();
    public void removeOpElement(ElementOperation arg);
    public ElementOperation getOpCopy();
    public boolean canAddElement();

    public int getOpElementLevel();

    public boolean acceptOpElement(ElementOperation e);
    public ModuleModel getParentModule();

    public static final int ELEMENT = 0;
    public static final int HEDGE = 1;
    public static final int OBJECT = 2;
    public static final int ATTRIBUTE = 3;
}


