/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.util.ArrayList;


import java.util.List;
import java.text.MessageFormat;
import java.util.Arrays;



public class ElementUtil {

    public static AttributePoolModel getAttributePool(String role) {
	return new AttributePoolModel(role);
    }
    public static ConcreteAttributeModel getAttribute(String name) {
	return new ConcreteAttributeModel(name,"string",true);
    }
    public static AttributeRefModel getAttributeRef(AttributePoolModel pool) {
	return new AttributeRefModel(pool);
    }

    public static void addAttribute(ObjectModel obj,String name) {
	obj.addAttribute(getAttribute(name));
    }

    public static ObjectModel addRootObject(ModuleModel mm,String role) {
	ObjectModel obj = new ObjectModel(mm,role); 
	mm.addRootObject(obj);
	return obj;
    }

    public static ElementOperation [] toArray(ElementOperation arg) {
	return new ElementOperation[] {arg};
    }

    public static ObjectModel getObject(ModuleModel mm,String name) {
	return new ObjectModel(mm,name);
    }
    public static RefElementModel getRefObject(ModuleModel mm,String name) {
	return getRef(mm,getObject(mm,name));
    }
    public static RefElementModel getRef(ModuleModel mm,ObjectModel obj) {
	return new RefElementModel(mm,obj);
    }
    public static HedgeRefElementModel getHedgeRef(ModuleModel mm,
						   HedgeRuleElementModel r) {
	return new HedgeRefElementModel(mm,r);
    }
    public static HedgeRuleElementModel getHedgeRule(ModuleModel mm,String r) {
	return new HedgeRuleElementModel(mm,r);
    }
    public static MixedModel getMixed(ModuleModel mm) {
	return new MixedModel(mm);
    }
    public static SequenceElementModel getSequence(ModuleModel mm) {
	return new SequenceElementModel(mm);
    }
    public static ChoiceElementModel getChoice(ModuleModel mm) {
	return new ChoiceElementModel(mm);
    }
    public static NoneElementModel getNone(ModuleModel mm) {
	return new NoneElementModel(mm);
    }
    public static EmptyElementModel getEmpty(ModuleModel mm) {
	return new EmptyElementModel(mm);
    }

    public static AbstractElementModel sequence(ModuleModel mm,
						ObjectModel [] objects) {
	SequenceElementModel seq  = getSequence(mm);
	for (int i=0;i<objects.length;i++) {
	    seq.addElement(new RefElementModel(mm,objects[i]));
	}
	return seq;
    }

    public static AbstractElementModel choice(ModuleModel mm,
					      ObjectModel [] objects) {
	ChoiceElementModel c = getChoice(mm);
	for (int i=0;i<objects.length;i++) {
	    c.addElement(new RefElementModel(mm,objects[i]));
	}
	return c;
    }

    public static RefElementModel [] getReferencesToMe(ModuleModel curModule,
						       ObjectModel object) {
	ReferenceCollector v = new ReferenceCollector(object);
	VisitorCenter.traverseAllInsideObjects(curModule,v);
	return v.getReferences();
    }

    public static String [] checkUsedObject(ModuleModel curModule,
					    ModuleModel mainModule) { 
	IncludeElementCheckVisitor v = 
	    new IncludeElementCheckVisitor(curModule,mainModule);
	VisitorCenter.traverseAllInsideObjects(mainModule,v);
	if (v.usedObjects.size() == 0) {
	    return null;
	}
	String [] ret = new String[v.usedObjects.size()];
	return (String[])v.usedObjects.toArray(ret);
    }
}

class ReferenceCollector extends VisitorClass {
    
    ObjectModel object;
    List references = new ArrayList();

    RefElementModel[] getReferences() {
	RefElementModel [] ret = new RefElementModel[references.size()];
	return (RefElementModel[])references.toArray(ret);
    }

    ReferenceCollector(ObjectModel obj) {
	object = obj;
    }
    
    public void ref(RefElementModel ref){
	if (ref.getAt() == object ) {
	    references.add(ref);
	}
    }

}

class IncludeElementCheckVisitor extends VisitorClass {
    List usedObjects = new ArrayList();
    ModuleModel curModule,mainModule;
    List curObjects = new ArrayList();
    
    IncludeElementCheckVisitor(ModuleModel curModule,ModuleModel mainModule) {
	this.curModule = curModule;
	this.mainModule = mainModule;
	curObjects.addAll(Arrays.asList(curModule.getAllObjects()));
	curObjects.addAll(Arrays.asList(curModule.getAllHedgeRules()));
	curObjects.addAll(Arrays.asList(curModule.getAllAttributePools()));
    }
    
    public int getAllowedNestedLoop() {
	return 0;
    }
    
    public boolean isOnlyFirstContact() {
	return true;
    }

    private String getRes(String mes,String name) {
	String [] args = {name};
	String f = MainApp.getResString(mes);
	return MessageFormat.format(f,args);
    }

    public void objectEnter(ObjectModel obj) {
	checkAttributes(obj.getAttributes());
    }

    private void checkAttributes(AttributeModel [] attrs) {
	for(int i=0;i<attrs.length;i++) {
	    if (attrs[i] instanceof AttributeRefModel) {
		AttributeRefModel ar = (AttributeRefModel)attrs[i];
		if (curObjects.contains(ar.getAt())) {
		    usedObjects.add(getRes("AttributePool{0}",
					   ar.getAt().getRole()));
		}
	    }
	}
    }

    public void end(ModuleModel m) {
	AttributePoolModel [] attrs = mainModule.getAttributePools();
	for(int i=0;i<attrs.length;i++) {
	    checkAttributes(attrs[i].getAttributes());
	}
    }
	
    public void hedgeRef(HedgeRefElementModel obj){   
	if (curObjects.contains(obj.getAt())) {
	    usedObjects.add(getRes("HedgeRule{0}",
				   obj.getAt().getLabel()));
	}
    }

    public void ref(RefElementModel obj){ 
	if (curObjects.contains(obj.getAt())) {
	    usedObjects.add(getRes("ElementRule{0}",
				   obj.getAt().getLabel()));
	}
    }
}


