/* MkRelax, Visual Relax Editor
 *	Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.util.ResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.text.MessageFormat;
import java.io.IOException;
import jp.gr.java_conf.ccs2.tool.mkrelax.gui.*;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.util.ExtensionFileFilter;
import jp.gr.java_conf.ccs2.comp.SwingUtil;
import jp.gr.java_conf.ccs2.core.AppContextClass;
import jp.gr.java_conf.ccs2.core.AppContext;
import jp.gr.java_conf.ccs2.core.AppConfig;
import jp.gr.java_conf.ccs2.core.MessageMonitor;


public class MainApp extends AppContextClass {

	//
	// start up
	// 

	static MainApp app;

	public static void main(String [] args) {
		app = new MainApp(args);
		app.printVersionString();
		app.getMonitor().debug(app.getMonitor().getState());
		app.getMonitor().debug(app.getConfig().getDumpProperties());
		app.setup();
	}

	protected MainApp(String [] args) {
		super(new AppConfig("jp.gr.java_conf.ccs2.tool.mkrelax.MkRelax",
							"MkRelax.properties",args),
			  "jp.gr.java_conf.ccs2.tool.mkrelax.message");
	}

	void printVersionString() {
		String [] args = {getResourceString("copyright"),
						  getResourceString("programName"),
						  getResourceString("version")};
		String form = "{0}\n{1} version {2}";
		System.out.println(MessageFormat.format(form,args));
	}
	
	void printUsage() {
		String ret = "Usage: java -jar mkrelax.jar [RELAX file]";
		System.out.println(ret);
	}
	
	void setup() {
		ModuleModel module = null;
		if (StringUtil.isNull(getConfig().getArgumentFile())) {
			module = ModuleModel.createNewModule();
		} else {
			try {
				module = ModuleModel.loadModuleFromRelax
					(getConfig().getArgumentFile());
			} catch (IOException e) {
				getMonitor().recordStackTrace(e);
			}
		}
		openFrame(module);
	}

	void openFrame(ModuleModel module) {
		magnify();
		MainFrame f = new MainFrame(new ModulePanel(module));
		f.pack();
		f.show();
	}

	void magnify() {
		if (getConfig().getOptionDouble("mag")>0) {
			SwingUtil.magnifyAllFont((float)getConfig().getOptionDouble("mag"));
		}
	}

	//
	// Handle Icon Resource 
	//
 
	ResourceBundle iconResources;
	boolean iconLoadFailed = false;

	protected void iconLoadResources() {
		try {
			iconResources = ResourceBundle.getBundle
				("jp.gr.java_conf.ccs2.tool.mkrelax.iconResource");
		} catch (MissingResourceException mre) {
			getMonitor().error("[iconResource.properties] not found");
			iconLoadFailed = true;
		}
	}

	public String getResourceString(String s) {
		if (iconResources == null && !iconLoadFailed) 
			iconLoadResources();
		String ret = null;
		try {
			ret = iconResources.getString(s);
		} catch (RuntimeException e) {
			//getMonitor().recordStackTrace(e);
		}
		if (ret == null) ret = super.getResourceString(s);
		getMonitor().debug("RES:"+s+" : "+ret);
		if (ret != null) return ret;
		getMonitor().warning("No properties : "+s);
		return s;
	}

	public static AppContext getAppContext() {
		if ( app == null) {
			temporaryContext();
		} // end of if ()
		return app;
	}

	public static String getResString(String resName) {
		return getAppContext().getResourceString(resName);
	}

	public static String getResString(String resName,String arg) {
		return ((MainApp)getAppContext()).getResourceString(resName,arg);
	}

	protected static void temporaryContext() {
		app = new MainApp(new String[0]);
	}
	
	public static ExtensionFileFilter getRelaxFileFilter() {
		ExtensionFileFilter relaxFileFilter = new ExtensionFileFilter(".rlx");
		relaxFileFilter.setDescription(getResString("RelaxModuleFile"));
		relaxFileFilter.addExtension(".rxm");
		return relaxFileFilter;
	}

}
