/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;
import java.io.Serializable;


public class MixedModel extends ElementModel  implements Serializable {

    static final long serialVersionUID = 4822652831778886921L;

    AbstractHedgeModel element;

    public MixedModel(ModuleModel mm) {
	super(mm);
    };
    public MixedModel(ModuleModel mm,AbstractHedgeModel a) {
	this(mm);
	setElement(a);
    }

    public void setElement(AbstractHedgeModel e) {
	element = e;
    }

    public AbstractHedgeModel getElement() {
	return element;
    }

    // ElementOperation stuff

    public boolean canAddElement() {
	return getElement() == null ? true : false;
    }
    public void addOpElements(ElementOperation [] args) {
	if (args == null || args.length==0) return;
	if (acceptOpElement(args[0])) {
	    if (args[0] instanceof AbstractHedgeModel) {
		setElement((AbstractHedgeModel)args[0]);
	    } else if (args[0] instanceof ObjectModel) {
		setElement(ElementUtil.getRef(getParentModule(),
					      (ObjectModel)args[0]));
	    } else {
		throw new InternalError("Object is now the subclass of AbstractHedgeModel.(bug)");
	    }
	}
    }
    public ElementOperation [] getOpElements() {
	if (getElement() == null) return null;
	ElementOperation [] ret = {getElement()};
	return ret;
    }
    public void removeOpElement(ElementOperation arg) {
	if (arg == getElement()) {
	    setElement(null);
	    return;
	} else if (getElement() instanceof RefElementModel) {
	    RefElementModel ref = (RefElementModel)getElement();
	    if (ref.getAt() == arg) {
		setElement(null);
		return;
	    }
	}
	throw new InternalError("Invalid argument.");
    }
    public ElementOperation getOpCopy() {
	MixedModel ret = ElementUtil.getMixed(getParentModule());
	if (getOpElements() != null) {
	    ret.addOpElements
		(ElementUtil.toArray(getOpElements()[0].getOpCopy()));
	}
	return ret;
    }

    public int getOpElementLevel() {
	return ELEMENT;
    }
    public boolean acceptOpElement(ElementOperation e) {
	if (e.getOpElementLevel() == HEDGE ||
	    e.getOpElementLevel() == OBJECT) {
	    return true;
	}
	return false;
    }
    
}


