/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;
import java.util.*;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.io.Serializable;


public class ObjectModel implements ElementOperation,AttributeOperation,Serializable{

    static final long serialVersionUID = -5037952455287831490L;
    ElementModel element;
    String tagName,label,comment;
    DataType type = DataType.RLX_ELEMENT;
    boolean export = false;
    List attributes = new ArrayList();
    ModuleModel parentModule;

    public ObjectModel(ModuleModel mm,String tagName) {
	this(mm,tagName,tagName);
	MainApp.getAppContext().getMonitor().debug("OBJECT:"+type);
    }

    public ObjectModel(ModuleModel mm,String tagName,String label) {
	this.parentModule = mm;
	this.tagName = tagName;
	this.label = label;
    }
    
    public ModuleModel getParentModule() {
	return parentModule;
    }

    public void setType(DataType a) {
	if (getElement() == null) {
	    type = a;
	} else if (!a.equals(DataType.RLX_ELEMENT)) {
	    throw new InternalError("Forbidden operation.");
	} else {
	    type = DataType.RLX_ELEMENT;
	}
	MainApp.getAppContext().getMonitor().debugStackTrace("OBJECT-:"+type);
    }

    public void setType(String a) {
	setType(DataType.getTypeByName(a));
    }

    public DataType getType() {
	return type; 
    }

    public boolean isExportable() {
	return export;
    }

    public void setExportable(boolean b) {
	export = b;
    }

    public String getTagName() {
	return tagName;
    }

    public void setTagName(String  v) {
	this.tagName = v;
    }

    public String getLabel() {
	return label;
    }

    public void setLabel(String  v) {
	this.label = v;
    }

    public boolean isLabelEqTag() {
	return tagName.equals(label);
    }

    public String getComment() {
	return comment;
    }

    public void setComment(String  v) {
	this.comment = v;
    }
    
    public void setElement(ElementModel e) {
	if (getType() == DataType.RLX_ELEMENT) {
	    element = e;
        } else {
	    throw new InternalError("Forbidden operation.");
	}
    }

    public ElementModel getElement() {
	return element;
    }

    public void addAttribute(AttributeModel em) {
	if (em == null) return;
	attributes.add(em);
    }

    public void removeAttribute(AttributeModel em) {
	if (em == null) return;
	attributes.remove(em);
    }

    public AttributeModel  []  getAttributes() {
        AttributeModel [] ar = new AttributeModel[attributes.size()];
        return (AttributeModel[]) attributes.toArray(ar);
    }

    public int getAttributeNum() {
	return attributes.size();
    }
    
    protected void copyTo(ObjectModel copy) {
	copy.setTagName(getTagName());
	copy.setLabel(getLabel());
	copy.setComment(getComment());
	copy.setType(getType());
	AttributeModel [] atr = getAttributes();
	for (int i=0;i<atr.length;i++) {
	    copy.addAttribute(atr[i].getCopy());
	}
    }

    // ElementOperation stuff

    public boolean canAddElement() {
	return (getElement() == null && getType() == DataType.RLX_ELEMENT)
	    ? true : false;
    }

    public void addOpElements(ElementOperation [] args) {
	if (args == null || args.length==0) return;
	if (acceptOpElement(args[0])) {
	    if (args[0] instanceof ElementModel) {
		setElement((ElementModel)args[0]);
	    } else if (args[0] instanceof ObjectModel) {
		setElement(ElementUtil.getRef(getParentModule(),
					      (ObjectModel)args[0]));
	    } else {
		throw new InternalError("Object is now the subclass of ElementModel.(bug)");
	    }
	}
    }
    public ElementOperation [] getOpElements() {
	if (getElement() == null) return null;
	ElementOperation [] ret = {getElement()};
	return ret;
    }
    public void removeOpElement(ElementOperation arg) {
	if (arg == getElement()) {
	    setElement(null);
	    return;
	} else if (getElement() instanceof RefElementModel) {
	    RefElementModel ref = (RefElementModel)getElement();
	    if (ref.getAt() == arg) {
		setElement(null);
		return;
	    }
	}
	throw new InternalError("Invalid argument.");
    }
    public ElementOperation getOpCopy() {
	ObjectModel ret = ElementUtil.getObject(getParentModule(),
						getTagName());
	copyTo(ret);
	if (getOpElements() != null) {
	    ret.addOpElements
		(ElementUtil.toArray(getOpElements()[0].getOpCopy()));
	}
	return ret;
    }

    public int getOpElementLevel() {
	return OBJECT;
    }
    public boolean acceptOpElement(ElementOperation e) {
	if (e.getOpElementLevel() == ELEMENT ||
	    e.getOpElementLevel() == HEDGE || 
	    e.getOpElementLevel() == OBJECT) {
	    return true;
	}
	return false;
    }
    

    // Serialization utility

    private void readObject(ObjectInputStream s) throws IOException,ClassNotFoundException  {
	s.defaultReadObject();
	setType(type.getTypeName());
    }
}


