/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;

import java.io.Serializable;



public class RefElementModel extends AbstractElementModel implements Serializable{
    static final long serialVersionUID = -3362369654901134592L;

    ObjectModel at ;

    public RefElementModel(ModuleModel mm) {super(mm);}
    public RefElementModel(ModuleModel mm,ObjectModel a) {
	this(mm,a,"");
    }
    public RefElementModel(ModuleModel mm,ObjectModel a,String occurs) {
	this(mm);
	setAt(a);
	setOccurs(occurs);
    }

    public void setAt(ObjectModel a) { at = a; }
    public ObjectModel getAt() { return at; }

    // ElementOperation stuff

    public boolean canAddElement() {
	return getAt() == null ? true : false;
    }
    public void addOpElements(ElementOperation [] args) {
	if (args == null || args.length==0) return;
	if (args[0].getOpElementLevel() == OBJECT) {
	    if (args[0] instanceof ObjectModel)
		setAt((ObjectModel)args[0]);
	    else 
		throw new InternalError("Object is now the subclass of ObjectModel.(bug)");
	}
    }
    public ElementOperation [] getOpElements() {
	if (getAt() == null) return null;
	if (getAt() instanceof ElementOperation) {
	    ElementOperation [] ret = {(ElementOperation)getAt()};
	    return ret;
	} else 
	    throw new InternalError("Object is now the subclass of ObjectModel.(bug)");
    }
    public void removeOpElement(ElementOperation arg) {
	if (arg == getAt()) {
	    setAt(null);
	}
    }
    public ElementOperation getOpCopy() {
	RefElementModel ret = ElementUtil.getRef(getParentModule(),getAt());
	copyTo(ret);
	return ret;
    }

    public boolean acceptOpElement(ElementOperation e) {
	if (e.getOpElementLevel() == OBJECT) {
	    return true;
	}
	return false;
    }

}


