/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax;


public interface Visitor {

    public int getAllowedNestedLoop();
    public boolean isOnlyFirstContact();
    
    public void start(ModuleModel m);
    public void end(ModuleModel m);
    
    public void root(ObjectModel obj);

    public void objectEnter(ObjectModel obj,int loop);
    public void objectExit(ObjectModel obj);

    public void hedgeRuleEnter(HedgeRuleElementModel obj);
    public void hedgeRuleExit(HedgeRuleElementModel obj);

    public void mixedEnter(MixedModel obj);
    public void mixedExit(MixedModel obj);

    public void none(NoneElementModel obj);
    public void empty(EmptyElementModel obj);

    public void choiceEnter(ChoiceElementModel obj);
    public void choiceExit(ChoiceElementModel obj);

    public void sequenceEnter(SequenceElementModel obj);
    public void sequenceExit(SequenceElementModel obj);

    public void hedgeRef(HedgeRefElementModel obj);
    public void ref(RefElementModel obj);
}


