package jp.gr.java_conf.ccs2.tool.mkrelax.datatype;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Datatypes</b> is generated by Relaxer based on datatypes.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="datatypes">
 *   <tag/>
 *   <sequence>
 *     <element name="defaultType" type="string"/>
 *     <ref label="entries"/>
 *   </sequence>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="datatypes"&gt;
 *   &lt;tag/&gt;
 *   &lt;sequence&gt;
 *     &lt;element name="defaultType" type="string"/&gt;
 *     &lt;ref label="entries"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version datatypes.rlx 1.0 (Wed Oct 03 14:35:06 JST 2001)
 * @author  Relaxer 0.14.2 (http://www.relaxer.org)
 */
public class Datatypes implements java.io.Serializable {
    private String defaultType_;
    private Entries entries_;

    /**
     * Creates a <code>Datatypes</code>.
     *
     */
    public Datatypes() {
    }

    /**
     * Creates a <code>Datatypes</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Datatypes(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Datatypes</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Datatypes(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Datatypes</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Datatypes(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Datatypes</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Datatypes(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Datatypes</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Datatypes(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Datatypes</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Datatypes(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Datatypes</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Datatypes(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Datatypes</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Datatypes(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Datatypes</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Datatypes(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Datatypes</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Datatypes</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Datatypes</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        defaultType_ = URelaxer.getElementPropertyAsString(stack.popElement());
        setEntries(new Entries(stack));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("datatypes");
        int size;
        URelaxer.setElementPropertyByString(element, "defaultType", this.defaultType_);
        this.entries_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Datatypes</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Datatypes</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Datatypes</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Datatypes</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Datatypes</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Datatypes</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>defaultType</b>.
     *
     * @return String
     */
    public final String getDefaultType() {
        return (defaultType_);
    }

    /**
     * Sets the String property <b>defaultType</b>.
     *
     * @param defaultType
     */
    public final void setDefaultType(String defaultType) {
        this.defaultType_ = defaultType;
    }

    /**
     * Gets the Entries property <b>entries</b>.
     *
     * @return Entries
     */
    public final Entries getEntries() {
        return (entries_);
    }

    /**
     * Sets the Entries property <b>entries</b>.
     *
     * @param entries
     */
    public final void setEntries(Entries entries) {
        this.entries_ = entries;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<datatypes");
        buffer.append(">");
        buffer.append("<defaultType>");
        buffer.append(URelaxer.escapeCharData(getDefaultType()));
        buffer.append("</defaultType>");
        entries_.makeTextElement(buffer);
        buffer.append("</datatypes>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<datatypes");
        buffer.print(">");
        buffer.print("<defaultType>");
        buffer.print(URelaxer.escapeCharData(getDefaultType()));
        buffer.print("</defaultType>");
        entries_.makeTextElement(buffer);
        buffer.print("</datatypes>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Datatypes</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "datatypes")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "defaultType")) {
            return (false);
        }
        if (!Entries.isMatchHungry(target)) {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Datatypes</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Datatypes</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
