package jp.gr.java_conf.ccs2.tool.mkrelax.datatype;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Entries</b> is generated by Relaxer based on datatypes.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="entries">
 *   <tag/>
 *   <element name="entry" occurs="*" type="string"/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="entries"&gt;
 *   &lt;tag/&gt;
 *   &lt;element name="entry" occurs="*" type="string"/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version datatypes.rlx 1.0 (Wed Oct 03 14:35:07 JST 2001)
 * @author  Relaxer 0.14.2 (http://www.relaxer.org)
 */
public class Entries implements java.io.Serializable {
    // List<String>
    private java.util.List entry_ = new java.util.ArrayList();

    /**
     * Creates a <code>Entries</code>.
     *
     */
    public Entries() {
    }

    /**
     * Creates a <code>Entries</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Entries(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Entries</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Entries(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Entries</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Entries(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Entries</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Entries(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Entries</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Entries(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Entries</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Entries(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Entries</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Entries(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Entries</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Entries(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Entries</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Entries(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Entries</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Entries</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Entries</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        entry_ = URelaxer.getElementPropertyAsStringListByStack(stack, "entry");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("entries");
        int size;
        URelaxer.setElementPropertyByStringList(element, "entry", this.entry_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Entries</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Entries</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Entries</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Entries</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Entries</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Entries</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>entry</b>.
     *
     * @return String[]
     */
    public final String[] getEntry() {
        String[] array = new String[entry_.size()];
        return ((String[])entry_.toArray(array));
    }

    /**
     * Sets the String property <b>entry</b>.
     *
     * @param entry
     */
    public final void setEntry(String[] entry) {
        this.entry_.clear();
        this.entry_.addAll(java.util.Arrays.asList(entry));
    }

    /**
     * Sets the String property <b>entry</b>.
     *
     * @param entry
     */
    public final void setEntry(String entry) {
        this.entry_.clear();
        this.entry_.add(entry);
    }

    /**
     * Adds the String property <b>entry</b>.
     *
     * @param entry
     */
    public final void addEntry(String entry) {
        this.entry_.add(entry);
    }

    /**
     * Gets number of the String property <b>entry</b>.
     *
     * @return int
     */
    public final int getEntryCount() {
        return (entry_.size());
    }

    /**
     * Gets the String property <b>entry</b> by index.
     *
     * @param index
     * @return String
     */
    public final String getEntry(int index) {
        return ((String)entry_.get(index));
    }

    /**
     * Sets the String property <b>entry</b> by index.
     *
     * @param index
     * @param entry
     */
    public final void setEntry(int index, String entry) {
        this.entry_.set(index, entry);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<entries");
        buffer.append(">");
        size = getEntryCount();
        for (int i = 0;i < size;i++) {
            buffer.append("<entry>");
            buffer.append(URelaxer.escapeCharData(getEntry(i)));
            buffer.append("</entry>");
        }
        buffer.append("</entries>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<entries");
        buffer.print(">");
        size = getEntryCount();
        for (int i = 0;i < size;i++) {
            buffer.print("<entry>");
            buffer.print(URelaxer.escapeCharData(getEntry(i)));
            buffer.print("</entry>");
        }
        buffer.print("</entries>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Entries</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "entries")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while ((child = target.peekElement()) != null) {
            if (!URelaxer.isTargetElement(child, "entry")) {
                break;
            }
            target.popElement();
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Entries</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Entries</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
