/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import javax.swing.tree.DefaultTreeModel;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;


public class AttributePoolTreeModel extends DefaultTreeModel {

    ModuleModel module;
    MessageListener messageListener;
    TNAttributePoolRoot mainRoot;

    public AttributePoolTreeModel(ModuleModel mm,MessageListener ms) {
	super(new TNModule(null,null,null));
	module = mm;
	messageListener = ms;
	setupRoots();
    }

    void setupRoots() {
	mainRoot = getRootNode(module,new TNAttributePoolRoot(module,messageListener));
	setRoot(mainRoot);
	ModuleModel [] incs = module.getIncludeModules();
	for (int i=0;i<incs.length;i++) {
	    mainRoot.addAttribute
		(getRootNode(incs[i],new TNAttributePoolIncluded
		    (incs[i],mainRoot,messageListener)));
	}
    }

    TNAttributePoolRoot getRootNode(ModuleModel curModule,
				    TNAttributePoolRoot root) {
	AttributePoolModel [] pools = 
	    (curModule==module) ? curModule.getAttributePools() : 
	                          curModule.getAllAttributePools();
	for (int i=0;i<pools.length;i++) {
	    root.addAttribute
		(new TNAttributePool(root,pools[i],messageListener));
	}
	return root;
    }

    public TNAttributePoolRoot getMainRoot() {
	return mainRoot;
    }
    

}




