/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.URL;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.StringUtil;
import java.awt.Component;
import java.text.MessageFormat;

public class GuiUtil {

    public static JPopupMenu createPopupMenu(Object [][] args) {
		JPopupMenu menu = new JPopupMenu();
		createMenu(args,menu);
		return menu;
    }

    public static JMenu getSubmenu(String titleRes,Object [][] args) {
		JMenu menu = new JMenu(MainApp.getResString(titleRes));
		createMenu(args,menu);
		return menu;
    }

    public static void createMenu(Object [][] args,JComponent menu) {
		if (args == null) return;
		for (int i=0;i<args.length;i++) {
			if (args[i] == null || args[i].length == 0 || args[i][0] == null) {
				menu.add(new JPopupMenu.Separator());
				continue;
			}
			if (args[i][0] instanceof JMenu) {
				menu.add((JMenu)args[i][0]);
				continue;
			}
			if (args[i].length == 4) {
				menu.add(getMenuItem
						 ((String)args[i][0],(String)args[i][1],
						  (ActionListener)args[i][2],(Boolean)args[i][3]));
			} else {
				menu.add(getMenuItem
						 ((String)args[i][0],(String)args[i][1],
						  (ActionListener)args[i][2],
						  (String)args[i][3],
						  (Boolean)args[i][4]));
			}
		}
    }

    public static JMenuItem getMenuItem(String resName,String command,
										ActionListener action,Boolean on) {
		return getMenuItem(resName,command,action,null,on);
    }
    public static JMenuItem getMenuItem(String resName,String command,
										ActionListener action,String iconUri,
										Boolean on) {
		JMenuItem item = new JMenuItem
			(MainApp.getResString(resName));
		item.setActionCommand(command);
		item.addActionListener(action);
		if (!StringUtil.isNull(iconUri)) {
			URL url = item.getClass().getResource(iconUri);
			if (url != null)
				item.setIcon(new ImageIcon(url));
		}
		if (on == Boolean.FALSE) item.setEnabled(false);
		return item;
    }

    public static String inputDialog(Component com,String mesRes,
									 String titleRes) {
		String name = JOptionPane.showInputDialog
			(com,
			 MainApp.getResString(mesRes),
			 MainApp.getResString(titleRes),
			 JOptionPane.QUESTION_MESSAGE);
		return name;
    }
	
    public static void addAttribute(Component com,ObjectModel object) {
		String name = inputDialog(com,"inputAttributeName",
								  "addAttribute");
		if (StringUtil.isNull(name)) return;
		ElementUtil.addAttribute(object,name);
    }

}


