/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import javax.swing.tree.DefaultTreeModel;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;


public class ObjectTreeModel extends AbstractObjectTreeModel {

    public ObjectTreeModel(ModuleModel mm,MessageListener ms) {
	super(mm,ms);
    }

    protected TNElement createRootNode(ModuleModel m) {
	return new TNModule(m,getMessageListener());
    }
    protected TNElement createIncludedNode(ModuleModel m,
					   TNElement parent) {
	return new TNModuleIncluded(m,(TNModule)parent,getMessageListener());
    }

    protected void traverse(ModuleModel m,Visitor v) {
	VisitorCenter.traverseObject(m,v);
    }

    protected void traverseAll(ModuleModel m,Visitor v) {
	VisitorCenter.traverseObjectAroundAllModules(m,v);
    }
}





