/* MkRelax, Visual Relax Editor
 *	Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Component;
import javax.swing.UIManager;
import javax.swing.JTree;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeCellRenderer;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;

class ObjectTreeRenderer extends DefaultTreeCellRenderer {
	
	public ObjectTreeRenderer() {
	}

	public Component getTreeCellRendererComponent
		(JTree tree,
		 Object value,
		 boolean sel,
		 boolean expanded,
		 boolean leaf,
		 int row,
		 boolean hasFocus) {
	
		super.getTreeCellRendererComponent
			(tree, value, sel, expanded, leaf, row, hasFocus);
	
		putClientProperty("html", null);
		setForeground(getLabelColor(value));
		setFont(getCustomFont(value,getFont()));
		setIcon(getLabelIcon(value));

		return this;
	}
	
	Color ctrlElementColor = Color.blue;
	Color elementColor = Color.black;
	Color attributeColor = Color.green.darker();
	Color exportColor = Color.pink.darker();

	Color ctrlIncElementColor = Color.blue.brighter();
	Color elementIncColor = Color.gray;
	Color attributeIncColor = Color.green;
	Color exportIncColor = Color.pink;

	Font includedFont = new Font(UIManager.getFont("Tree.font").getName(),
								 Font.PLAIN,
								 UIManager.getFont("Tree.font").getSize());
	Font defalutFont = UIManager.getFont("Tree.font");
	
	protected Color getLabelColor(Object value) {
		boolean main = false;
		if (value instanceof TNCommon) {
			TNCommon obj = (TNCommon)value;
			main = obj.isEditableObject();
		}

		if (value instanceof TNMultiElement ||
			value instanceof TNMixed ||
			value instanceof TNHedgeRef) {
			return main ? ctrlElementColor : ctrlIncElementColor;
		}

		if (value instanceof TNConAttribute ||
			value instanceof TNAttributeRef) {
			return main ? attributeColor : attributeIncColor;
		}

		if (value instanceof TNObject) {
			TNObject obj = (TNObject)value;
			ObjectModel model = (ObjectModel)obj.getObject();
			if (model.isExportable())
				return main ? exportColor : exportIncColor;
		}

		return main ? elementColor : elementIncColor;
	}

	protected Font getCustomFont(Object value,Font afont) {
		if (value instanceof TNCommon) {
			TNCommon obj = (TNCommon)value;
			return obj.isEditableObject() ? defalutFont : includedFont;
		}
		return afont;
	}

	protected ImageIcon getLabelIcon(Object value) {
		if (value instanceof TNCommon) {
			return ((TNCommon)value).getImageIcon();
		}
		return null;
	}
}


