/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import java.text.MessageFormat;
import java.awt.Component;
import javax.swing.JOptionPane;
import java.util.Arrays;


public abstract class TNAttribute extends TNCommon {

    AttributeModel attribute;

    protected TNAttribute(TreeNode p,MessageListener ms,
			  AttributeModel at,String iconRes) {
	super(p,ms,iconRes);
	attribute = at;
    }

    public Object getObject() {
	return attribute;
    }

    public AttributeModel getAttribute() {
	return attribute;
    }

    protected String getRemoveName() {
	return toString();
    }

    ActionListener action;
    protected ActionListener getActionListener() {
	if (action == null)
	    action = new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			onAction(e);
		    }};
	return action;
    }

    protected void onAction(ActionEvent e) {
    }

    Object [][] createPopupMenu() {
	if (!isEditableObject()) return null;
	final JPopupMenu popMenu = new JPopupMenu();
	ActionListener action = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    removeBranch((Component)e.getSource(),false);
		}};
	Object [][] ret = {
	    {"attributeRemove","remove_attribute",action,
	     MainApp.getResString("IconEditRemoveBranch"),Boolean.TRUE}};
	return ret;
    }

    public void removeBranch(Component com, boolean direct) {
	if (!direct) {
	    String [] arg = {getRemoveName()};
	    String mes = MessageFormat.format
		(MainApp.getResString("DoYouRemoveAttribute{0}?"),arg);
	    int ret = JOptionPane.showConfirmDialog
		(com,mes,MainApp.getResString("RemoveConfirm"),
		 JOptionPane.YES_NO_OPTION);
	    if (ret != JOptionPane.YES_OPTION) return;
	}
	if (!(getTNParent().getObject() instanceof AttributeOperation))
	    throw new InternalError("Unexpected error.");
	AttributeOperation obj = (AttributeOperation)(getTNParent().getObject());
	obj.removeAttribute(getAttribute());
	getTNParent().sendTreeChangedMessage();
    }

}



