/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.StringUtil;
import java.util.List;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.JTextArea;
import javax.swing.JPanel;
import javax.swing.BoxLayout;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.FlowLayout;
import javax.swing.JScrollPane;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class TNAttributePool extends TNAttribute  {

    AttributePoolModel pool;

    public TNAttributePool(TreeNode p,AttributePoolModel pl,
			   MessageListener s) {
	super(p,s,null,"IconAttPool");
	pool = pl;
	initNode();
    }

    void initNode() {
	AttributeModel [] atm = pool.getAttributes();
	List list = new ArrayList();
	for (int i=0;i<atm.length;i++) {
	    if (atm[i] instanceof ConcreteAttributeModel) {
		list.add(new TNConAttribute(getParent(),getMessageListener(),
					    (ConcreteAttributeModel)atm[i]));
	    } else if (atm[i] instanceof AttributeRefModel) {
		list.add(new TNAttributeRef(getParent(),getMessageListener(),
					    (AttributeRefModel)atm[i]));
	    } else {
		throw new InternalError("Invalid attribute entry.");
	    }
	}
	TreeNode [] ss = new TreeNode[list.size()];
	setChildren((TreeNode[])list.toArray(ss));
    }

    public Object getObject() {
	return pool;
    }

    JPanel panel = null;
    JTextField nameField;
    JTextArea commentField;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

	    nameField = new JTextField(20);
	    panel.add(setupComponent(nameField,"attributePoolRole"));

	    commentField = new JTextArea(3,20);
	    panel.add(setupTextArea(commentField,"attributeComment"));
	}

	updateComponentsFromData();
	return panel;
    }

    protected void updateDataFromComponents() {
	pool.setRole(nameField.getText());
	pool.setComment(commentField.getText());
	sendRepaintMessage();
    }

    protected void updateComponentsFromData() {
	nameField.setText(pool.getRole());
	commentField.setText(pool.getComment());
    }

    protected Object [][] getPopupMenuResource() {
	if (!isEditableObject()) return null;
	Object [][] attMenus = {
	    {"addAttribute",ADD_ATTRIBUTE,
	     getActionListener(),
	     MainApp.getResString("IconAttribute"),
	     Boolean.TRUE},
	    {"addAttributeRef",ADD_ATTREF,
	     getActionListener(),
	     MainApp.getResString("IconAttPoolRef"),
	     Boolean.TRUE},
	    {null},
	    {"RemoveBranch",REMOVE_BRANCH,
	     getActionListener(),
	     MainApp.getResString("IconEditRemoveBranch"),
	     Boolean.TRUE},
	};
	return attMenus;
    }

    protected void onAction(ActionEvent e) {
	if (e.getActionCommand() == ADD_ATTRIBUTE) {
	    addAttribute((Component)e.getSource());
	} else if (e.getActionCommand() == ADD_ATTREF) {
	    addAttributeRef((Component)e.getSource());
	} else if (e.getActionCommand() == REMOVE_BRANCH) {
	    removeBranch((Component)e.getSource(),false);
	} else {
	    throw new InternalError("No such event.");
	}
    }

    public void removeBranch(Component com, boolean direct) {
	if (!direct){
	    String [] arg = {pool.getRole()};
	    String mes = MessageFormat.format
		(MainApp.getResString("DoYouRemoveAttributePool{0}?"),arg);
	    int ret = JOptionPane.showConfirmDialog
		(com,mes,
		 MainApp.getResString("RemoveConfirm"),
		 JOptionPane.YES_NO_OPTION);
	    if (ret != JOptionPane.YES_OPTION) return;
	}
	getModule().removeAttributePool(pool);
	getTNParent().sendTreeChangedMessage();
    }

    void addAttribute(Component com) {
	String role = GuiUtil.inputDialog
	    (com,"inputAttributeName","addAttribute");
	if (StringUtil.isNull(role)) return;
	
	pool.addAttribute(ElementUtil.getAttribute(role));
	sendTreeChangedMessage();
    }

    void addAttributeRef(Component com) {
	AttributePoolModel attpool = chooseAttributePool(com);
	if (attpool == null) return;
	pool.addAttribute(ElementUtil.getAttributeRef(attpool));
	sendTreeChangedMessage();
    }

    public String toString() {
	return "["+pool.getRole()+"]";
    }

    public boolean getAllowsChildren() {
	return true;
    }

}
