/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.StringUtil;

public class TNAttributePoolRoot extends TNAttribute  {

    ModuleModel module;

    protected TNAttributePoolRoot(TreeNode p,ModuleModel m,MessageListener s) {
	super(p,s,null,"IconModule");
	module = m;
    }

    public TNAttributePoolRoot(ModuleModel m,MessageListener s) {
	super(null,s,null,"IconModule");
	module = m;
    }

    public Object getObject() {
	return module;
    }

    protected ModuleModel getMainModule() {
	return module;
    }

    public void addAttribute(TNAttribute node) {
	addChild(node);
    }

    JPanel panel = null;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.add(new JLabel(MainApp.getResString("noProperty")));
	}
	return panel;
    }

    protected Object [][] getPopupMenuResource() {
	if (!isEditableObject()) return null;
	Object [][] attMenus = {
	    {"addAttributePool",ADD_ATTPOOL,
	     getActionListener(),
	     MainApp.getResString("IconAttPool"),
	     Boolean.TRUE},
	};
	return attMenus;
    }

    protected void onAction(ActionEvent e) {
	if (e.getActionCommand() == ADD_ATTPOOL) {
	    addAttributePool((Component)e.getSource());
	} else {
	    throw new InternalError("No such event.");
	}
    }

    public void removeBranch(Component com,boolean d) {
	throw new InternalError("Forbidden opration.");
    }

    void addAttributePool(Component com) {
	String role = GuiUtil.inputDialog
	    (com,"inputAttributePool","addAttributePool");
	if (StringUtil.isNull(role)) return;
	
	module.addAttributePool(ElementUtil.getAttributePool(role));
	sendTreeChangedMessage();
    }

    public String toString() {
	return "[Module]";
    }


}
