/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.FlowLayout;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import java.awt.Component;
import java.text.MessageFormat;

public class TNAttributeRef extends TNAttribute {

    public TNAttributeRef(TreeNode p,MessageListener ms,
			  AttributeRefModel at) {
	super(p,ms,at,"IconAttPoolRef");
    }

    public AttributeRefModel getAttributeRef() {
	return (AttributeRefModel)attribute;
    }

    protected String getRemoveName() {
	AttributePoolModel apm = getAttributeRef().getAt();
	if (apm != null) {
	    String [] arg = {apm.getRole()};
	    String mes = MessageFormat.format
		(MainApp.getResString("ReferenceTo{0}"),arg);
	    return mes;
	}
	return MainApp.getResString("Reference");
    }

    protected Object [][] getPopupMenuResource() {
	Object [][] menu = createPopupMenu();
	return menu;
    }

    JPanel panel;
    JButton roleButton;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

	    ActionListener actionListener = new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			selectPoolAttribute((Component)e.getSource());
		    }
		};
	    
	    roleButton = new JButton("----");
	    roleButton.addActionListener(actionListener);
	    panel.add(setupButton(roleButton,"attributeRef"));
	}
	roleButton.setText(getAttributeRef().getAt().getRole());

	return panel;
    }

    void selectPoolAttribute(Component com) {
	AttributePoolModel atp = chooseAttributePool(com);
	if (atp == null)return;
	getAttributeRef().setAt(atp);
	sendTreeChangedMessage();
    }

    public String toString() {
	AttributePoolModel apm = getAttributeRef().getAt();
	if (apm != null) {
	    return "ref : "+apm.getRole();
	}
	return "---";
    }

    public boolean getAllowsChildren() {
	return false;
    }

}
