/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import java.awt.event.ActionEvent;

public class TNChoice extends TNMultiElement  {

    public TNChoice(TreeNode parent,MessageListener ms,ChoiceElementModel m) {
	super(parent,ms,m,"IconChoice");
    }

    public String toString() {
	return toString("ChoiceLabel");
    }

    protected Object [][] getPopupMenuResource() {
	Object [][] args = super.getPopupMenuResource();
	if (isEditableObject()) {
	    Object [][] attMenus = {
		{"changeIntoSequence",CHANGE_SEQ,
		 getAddActionListener(),
		 MainApp.getResString("IconChangeMulti"),
		 Boolean.TRUE},
		{null},
	    };
	    args = appendCustomMenusBefore(args,attMenus);
	}
	return args;
    }

    protected void menuAdd(ActionEvent e) {
	if (e.getActionCommand() == CHANGE_SEQ) {
	    changeIntoSequence();
	} else {
	    super.menuAdd(e);
	}
    }

    void changeIntoSequence() {
	changeMulti(ElementUtil.getSequence(getModule()));
    }
}


