/* MkRelax, Visual Relax Editor
 *	Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.util.Enumeration;
import javax.swing.*;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.util.SimpleEnumeration;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;
import java.awt.event.FocusListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import javax.swing.text.JTextComponent;
import java.awt.FlowLayout;
import javax.swing.border.TitledBorder;
import java.awt.ItemSelectable;

public abstract class TNCommon implements TreeNode	{

	private MessageListener messageListener = null;
	private TreeNode parent = null; 
	private TreeNode [] children = null;
	private ImageIcon icon = null;

	//post-set object
	KeyListener keyListener;

	protected TNCommon(TreeNode parent,MessageListener ms,String iconRes) {
		this.parent = parent;
		this.messageListener = ms;

		if (!StringUtil.isNull(iconRes)) {
			try {
				URL url = iconRes.getClass().getResource
					(getResourceString(iconRes));
				if (url != null)
					icon = new ImageIcon(url);
			} catch (RuntimeException e) {
				MainApp.getAppContext().getMonitor().warning("Icon file "+iconRes+" not found.");
			}
		}
	}

	public JPanel getPropertyPaneGen(KeyListener keyListener) {
		this.keyListener = keyListener;
		return getPropertyPane();
	}

	abstract public JPanel getPropertyPane();

	abstract public Object getObject();

	public boolean isEditableObject() {
		return getMainModule() == getModule();
	}

	protected ModuleModel getMainModule() {
		if (getTNParent()!=null)
			return getTNParent().getMainModule();
		MainApp.getAppContext().getMonitor().error("Stopped MainModule chain. : "+getClass().getName());
		throw new InternalError("Stopped MainModule chain.");
	}
	
	public ImageIcon getImageIcon() {
		return icon;
	}

	protected void sendRepaintMessage() {
		if (messageListener != null)
			messageListener.message(null,messageListener.REPAINT,this);
	}
	protected void sendTreeChangedMessage() {
		if (messageListener != null)
			messageListener.message(null,messageListener.DISPOSE,this);
	}
	protected MessageListener getMessageListener() {
		return messageListener;
	}
	protected KeyListener getKeyListener() {
		if (keyListener == null) throw new InternalError("KeyListener is null!");
		return keyListener;
	}

	public TNCommon getTNParent() {
		if (getParent() instanceof TNCommon) {
			return (TNCommon)getParent();
		}
		return null;
	}

	protected String getResourceString(String arg) {
		return MainApp.getResString(arg);
	}

	public abstract void removeBranch(Component com,boolean direct);

	// utility for subclasses

	FocusListener focusListener = new FocusAdapter()  {
			public void focusLost(FocusEvent e) {
				updateDataFromComponents();
			}
		};
	ActionListener actionListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				updateDataFromComponents();
			}
		};
	ItemListener itemListener = new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				updateDataFromComponents();
			}
		};

	protected JPanel setupTextArea(JTextArea com,
								   String titleRes) {
		com.setLineWrap(true);
		JPanel pn = setupComponentGen(com,titleRes);
		pn.add(new JScrollPane(com));
		return pn;
	}

	protected JPanel setupComponent(Component com,
									String titleRes) {
		JPanel pn = setupComponentGen(com,titleRes);
		if (com instanceof ItemSelectable) {
			((ItemSelectable)com).addItemListener(itemListener);
		}
		if (com instanceof JTextComponent) {
			((JTextField)com).addActionListener(actionListener);
		} else if (com instanceof AbstractButton) {
			((AbstractButton)com).addActionListener(actionListener);
		}
		addComponentAndLabel(pn,com,titleRes);
		return pn;
	}

	protected JPanel setupButton(Component com,
								 String titleRes) {
		JPanel pn = setupComponentGen(com,titleRes);
		addComponentAndLabel(pn,com,titleRes);
		return pn;
	}

	protected JPanel setupItem(AbstractButton com,
							   String titleRes) {
		JPanel pn = setupComponentGen(com,titleRes);
		addComponentAndLabel(pn,com,titleRes);
		com.addItemListener(itemListener);
		return pn;
	}

	private JPanel setupComponentGen(Component com,
									 String titleRes) {
		com.addFocusListener(focusListener);
		com.addKeyListener(getKeyListener());
		com.setEnabled(isEditableObject());
		JPanel pn = new JPanel(new FlowLayout(FlowLayout.LEFT));
		pn.setBorder(new TitledBorder(getResourceString(titleRes)));
		pn.add(Box.createHorizontalStrut(6));
		return pn;
	}

	private void addComponentAndLabel(JPanel pn,Component com,
									  String titleRes) {
		String prelabel = ((MainApp)MainApp.getAppContext()).getResourceStringNoWarning("PRE_"+titleRes);
		if (prelabel != null) {
			pn.add(new JLabel(prelabel));
		}
		pn.add(com);
		String postlabel = ((MainApp)MainApp.getAppContext()).getResourceStringNoWarning("POST_"+titleRes);
		if (postlabel != null) {
			pn.add(new JLabel(postlabel));
		}
	}

	//override 
	protected void updateDataFromComponents() {
	}

	//override 
	protected void updateComponentsFromData() {
	}

	protected ModuleModel getModule() {
		TNCommon com = this;
		while(true) {
			if (com.getObject() instanceof ModuleModel) {
				return (ModuleModel)com.getObject();
			}
			if (com.getObject() instanceof ElementOperation) {
				return ((ElementOperation)com.getObject()).getParentModule();
			}
			com = com.getTNParent();
			if (com == null) break;
		}
		throw new InternalError("Can not find module object.");
	}

	protected AttributePoolModel chooseAttributePool(Component com) {
		//exclude parent attributePool
		TNCommon pp = this;
		AttributePoolModel exclude = null;
		while(pp != null) {
			if (pp instanceof TNAttributePool) {
				exclude = (AttributePoolModel)pp.getObject();
				break;
			}
			pp = pp.getTNParent();
		}
		AttributePoolModel [] attributes = 
			getModule().getAllAttributePools(exclude);
		//-----------------
		String [] entries = new String[attributes.length];
		for (int i=0;i<attributes.length;i++) {
			String name = attributes[i].getRole();
			entries[i] = name;
		}
		SelectionDialog dlg = new SelectionDialog
			(JOptionPane.getFrameForComponent(com),
			 getResourceString("selectAttribute"),
			 Arrays.asList(entries));
		dlg.show();
		if (dlg.getIndex() == -1) return null;
		return attributes[dlg.getIndex()];
	}

	//TreeNode implementation

	public TreeNode getParent() {
		return parent;
	}

	protected void setChildren(TreeNode [] tn) {
		children = tn;
	}

	protected TreeNode [] getChildren() {
		return children;
	}

	protected void addChild(TreeNode node) {
		List list = new ArrayList();
		if (getChildren()!=null) {
			list.addAll(Arrays.asList(getChildren()));
		}
		list.add(node);
		TreeNode [] ret = new TreeNode[list.size()];
		setChildren((TreeNode[])list.toArray(ret));
	}
	

	public int getIndex(TreeNode param1) {
		if (children == null) return -1;
		for (int i=0;i<children.length;i++) {
			if (param1 == children[i]) return i;
		}
		return -1;
	}

	public Enumeration children()	{
		if (children == null) return null;
		return new SimpleEnumeration(children);
	}

	public TreeNode getChildAt(int param1) {
		if (children == null) return null;
		return children[param1];
	}

	public int getChildCount()	{
		if (children == null) return 0;
		return children.length;
	}

	public boolean getAllowsChildren() {
		return true;
	}

	public boolean isLeaf()	 {
		if (children == null || children.length == 0) return true;
		return false;
	}

	public String toString() {
		return "[common]";
	}


	//
	// Menu resource
	//

	JPopupMenu popMenu;
	final public JPopupMenu getPopupMenu() {
		if (popMenu == null) {
			Object [][] res = getPopupMenuResource();
			if (res == null) return null;
			popMenu = GuiUtil.createPopupMenu(res);
		}
		return popMenu;
	}

	protected void clearPopupMenu() {
		popMenu = null;
	}

	//override to customize popup menu
	protected Object [][] getPopupMenuResource() {
		return null;
	}

	protected static Object [][] appendCustomMenuBefore(Object [][] menu,
														Object [] custom) {
		Object [][] ref = new Object[1][];
		ref[0]=custom;
		return appendCustomMenuBefore(menu,ref);
	}
	protected static Object [][] appendCustomMenusBefore(Object [][] menu,
														 Object [][] custom) {
		if (custom == null) return menu;
		if (menu == null) menu = new Object[0][0];
		Object [][] newref = new Object[menu.length+custom.length][];
		for (int i=0;i<custom.length;i++) {
			newref[i]=custom[i];
		}
		for (int i=0;i<menu.length;i++) {
			newref[custom.length+i]=menu[i];
		}
		return newref;
	}

	protected static Object [][] appendCustomMenuAfter(Object [][] menu,
													   Object [] custom) {
		Object [][] ref = new Object[1][];
		ref[0]=custom;
		return appendCustomMenusAfter(menu,ref);
	}
	protected static Object [][] appendCustomMenusAfter(Object [][] menu,
														Object [][] custom) {
		if (custom == null) return menu;
		if (menu == null) menu = new Object[0][0];
		Object [][] newref = new Object[menu.length+custom.length][];
		for (int i=0;i<menu.length;i++) {
			newref[i]=menu[i];
		}
		for (int i=0;i<custom.length;i++) {
			newref[menu.length+i]=custom[i];
		}
		return newref;
	}

	protected static final String ADD_ATTRIBUTE = "add_attr";
	protected static final String ADD_ATTREF = "add_attr_ref";
	protected static final String ADD_ATTPOOL = "add_attr_pool";
	protected static final String ADD_MIXED = "add_mixed";
	protected static final String ADD_SEQUENCE = "add_seq";
	protected static final String ADD_CHOICE = "add_choice";
	protected static final String ADD_REF = "add_ref";
	protected static final String ADD_REF_REUSE = "add_ref_reuse";
	protected static final String ADD_HEDGEREF = "add_hedge_ref";
	protected static final String ADD_HEDGERULE = "add_hedge_rule";
	protected static final String ADD_NONE = "add_none";
	protected static final String ADD_EMPTY = "add_empty";
	protected static final String REMOVE_BRANCH = "remove_branch";
	protected static final String REMOVE_CONNECT = "remove_connect";
	protected static final String MOVE_UP = "move_up";
	protected static final String MOVE_DOWN = "move_down";
	protected static final String REMOVE_MODULE = "remove_module";
	protected static final String RELOAD_MODULE = "reload_module";
	protected static final String INCLUDE_MODULE = "include_module";

	protected static final ObjectModel OBJECTMODEL = new ObjectModel(null,"");
	protected static final ElementModel ELEMENTMODEL = new MixedModel(null);
	protected static final AbstractHedgeModel HEDGEMODEL = new SequenceElementModel(null);

}



