/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.FlowLayout;
import java.awt.event.*;
import java.util.Arrays;
import javax.swing.*;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.border.TitledBorder;


public class TNConAttribute extends TNAttribute {

    public TNConAttribute(TreeNode p,MessageListener ms,
			  ConcreteAttributeModel at) {
	super(p,ms,at,"IconAttribute");
    }

    public ConcreteAttributeModel getConAttribute() {
	return (ConcreteAttributeModel)attribute;
    }

    JPanel panel;
    JTextField nameField;
    JTextArea commentField;
    JCheckBox requireCheck;
    JButton typeButton;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

	    nameField = new JTextField(20);
	    panel.add(setupComponent(nameField,"attributeName"));

	    commentField = new JTextArea(3,20);
	    panel.add(setupTextArea(commentField,"attributeComment"));

	    requireCheck = new JCheckBox();
	    panel.add(setupItem(requireCheck,"attributeRequire"));

	    typeButton = new JButton("-----");
	    typeButton.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			selectDataType();
		    }
		});
	    panel.add(setupButton(typeButton,"attributeType"));
	}

	updateComponentsFromData();
	return panel;
    }

    protected Object [][] getPopupMenuResource() {
	Object [][] menu = createPopupMenu();
	return menu;
    }

    void selectDataType() {
	SelectionDialog dialog = new SelectionDialog
	    (JOptionPane.getFrameForComponent(typeButton),
	     MainApp.getResString("selectDataType"),
	     Arrays.asList(DataType.dataTypes));
	dialog.show();
	if (dialog.getIndex() == -1) return;
	typeButton.setText(DataType.dataTypes[dialog.getIndex()].getTypeName());
	getConAttribute().setType(DataType.dataTypes[dialog.getIndex()]);
	sendRepaintMessage();
    }

    protected void updateDataFromComponents() {
	getConAttribute().setName(nameField.getText());
	getConAttribute().setComment(commentField.getText());
	getConAttribute().setRequired(requireCheck.isSelected());
	sendRepaintMessage();
    }

    protected void updateComponentsFromData() {
	nameField.setText(getConAttribute().getName());
	commentField.setText(getConAttribute().getComment());
	requireCheck.setSelected(getConAttribute().isRequired());
	typeButton.setText(getConAttribute().getType().getTypeName());
    }
    
    public String toString() {
	String ret = getConAttribute().getName()+":"+getConAttribute().getType().getTypeName();
	if (getConAttribute().isRequired()) ret += " [required]";
	return ret;
    }

    public boolean getAllowsChildren() {
	return false;
    }

}



