/* MkRelax, Visual Relax Editor
 *	Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.*;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.SimpleEnumeration;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import java.awt.Component;
import java.util.Arrays;
import java.text.MessageFormat;

public abstract class TNElement extends TNCommon  {

	public TNElement(TreeNode parent,MessageListener ms,
					 String iconRes) {
		super(parent,ms,iconRes);
	}

	//Should be called to get ready to show! (see ObjectTreeModel)
	abstract protected void setElements(TreeNode [] ems);

	//abstract public JPanel getPropetyPane();

	//abstract public Object getObject();

	public ElementOperation getElementOperation() {
		if (getObject() instanceof ElementOperation)
			return (ElementOperation)getObject();
		return null;
	}

	public TNElement getElParent() {
		if (getParent() instanceof TNElement) {
			return (TNElement)getParent();
		}
		return null;
	}

	protected ModuleModel getModule() {
		if (getElementOperation() != null) {
			return getElementOperation().getParentModule();
		}
		return super.getModule();
	}

	//
	// Menu resource
	//

	ActionListener addAction,inserAction,removeAction,moveAction;
	protected ActionListener getAddActionListener() {
		if (addAction == null)
			addAction = new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						menuAdd(e);
					}};
		return addAction;
	}

	protected ActionListener getInsertActionListener(ElementOperation child) {
		final ElementOperation fchild = child;
		//if (inserAction == null)
		inserAction = new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					menuInsertBefore(e,fchild);
				}};
		return inserAction;
	}

	protected ActionListener getRemoveActionListener() {
		if (removeAction == null)
			removeAction = new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						menuRemove(e);
					}};
		return removeAction;
	}

	protected ActionListener getMoveActionListener() {
		if (moveAction == null)
			moveAction = new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						menuMove(e);
					}};
		return moveAction;
	}

	protected static boolean reconnectCheck(ElementOperation left,
											ElementOperation target,
											ElementOperation right) {
		return left.acceptOpElement(target) && target.acceptOpElement(right);
	}

	protected static void reconnect(ElementOperation left,
									ElementOperation target,
									ElementOperation right) {
		left.removeOpElement(right);
		left.addOpElements(ElementUtil.toArray(target));
		if (right instanceof RefElementModel) {
			ObjectModel obj = ((RefElementModel)right).getAt();
			target.addOpElements(ElementUtil.toArray(obj));
		} else {
			target.addOpElements(ElementUtil.toArray(right));
		}
	}

	protected static boolean removeConnectCheck(ElementOperation left,
												ElementOperation target) {
		if (target.getOpElements() == null||
			target.getOpElements().length==0) return false;
		return left.acceptOpElement( target.getOpElements()[0] );
	}

	protected static void removeConnect(ElementOperation left,
										ElementOperation target) {
		left.removeOpElement(target);
		left.addOpElements(target.getOpElements());
	}

	//override to customize popup menu
	protected Object [][] getPopupMenuResource() {
		//standerd add element menu
		Object [][] menu = {{}};
		if (isEditableObject()) {
			menu = makeAddElementMenuResource
				(getElementOperation(),getAddActionListener());
			if (getObject() instanceof ModuleModel) {
				return menu;
			}
			menu = appendCustomMenuAfter(menu,new Object[]{null});
		}
		//insert menu
		Object [][] insMenu = getElParent().makeInsertMenuResource(this);
		if (insMenu != null) {
			menu = appendCustomMenuAfter
				(menu,new Object[] {GuiUtil.getSubmenu
									("InsertBefore",insMenu)});
			menu = appendCustomMenuAfter(menu,new Object[]{null});
		}
		//order change
		if (getElParent().getElementOperation() instanceof 
			AbstractMultiElementModel &&
			getElParent().isEditableObject()) {
			menu = appendCustomMenusAfter
				(menu,makeOrderChangeMenuResource
				 (getElementOperation(),getElParent().getElementOperation(),
				  getMoveActionListener()));
			menu = appendCustomMenuAfter(menu,new Object[]{null});
		}
		//change remove
		menu = appendCustomMenusAfter(menu,makeRemoveMenuResource
									  (getElementOperation(),
									   getElParent().getElementOperation(),
									   getRemoveActionListener()));
		return menu;
	}
	
	//called by child
	protected Object [][] makeInsertMenuResource(TNElement child) {
		if (!isEditableObject()) return null;
		return makeInsertElementMenuResource
			(this.getElementOperation(),
			 child.getElementOperation(),
			 getInsertActionListener(child.getElementOperation()));
	}

	protected void menuMove(ActionEvent e) {
		ElementOperation pr = getElParent().getElementOperation();
		if (!(pr instanceof AbstractMultiElementModel)) 
			throw new InternalError("Forbidden operation.");
		AbstractMultiElementModel ab = (AbstractMultiElementModel)pr;

		if (e.getActionCommand() == MOVE_UP) {
			ab.moveElementUpward(getElementOperation());
		} else if (e.getActionCommand() == MOVE_DOWN) {
			ab.moveElementDownward(getElementOperation());
		} else {
			throw new InternalError("no such action command.");
		}
		sendTreeChangedMessage();
	}

	protected void menuAdd(ActionEvent e) {
		if (e.getActionCommand() == ADD_REF) {
			addObject((Component)e.getSource());
		} else if (e.getActionCommand() == ADD_REF_REUSE) {
			addRef((Component)e.getSource());
		} else if (e.getActionCommand() == ADD_MIXED) {
			addMixed((Component)e.getSource());
		} else if (e.getActionCommand() == ADD_SEQUENCE) {
			addSequence((Component)e.getSource());
		} else if (e.getActionCommand() == ADD_CHOICE) {
			addChoice((Component)e.getSource());
		} else if (e.getActionCommand() == ADD_HEDGEREF) {
			addHedgeRef((Component)e.getSource());
		} else if (e.getActionCommand() == ADD_NONE) {
			addNone((Component)e.getSource());
		} else if (e.getActionCommand() == ADD_EMPTY) {
			addEmpty((Component)e.getSource());
		} else {
			throw new InternalError("no such action command.");
		}
	}

	protected void menuInsertBefore(ActionEvent e,ElementOperation child) {
		if (e.getActionCommand() == ADD_REF) {
			insertObject((Component)e.getSource(),child);
		} else if (e.getActionCommand() == ADD_MIXED) {
			insertMixed((Component)e.getSource(),child);
		} else if (e.getActionCommand() == ADD_SEQUENCE) {
			insertSequence((Component)e.getSource(),child);
		} else if (e.getActionCommand() == ADD_CHOICE) {
			insertChoice((Component)e.getSource(),child);
		} else {
			throw new InternalError("no such action command.");
		}
	}

	protected void menuRemove(ActionEvent e) {
		if (e.getActionCommand() == REMOVE_BRANCH) {
			removeBranch((Component)e.getSource(),false);
		} else if (e.getActionCommand() == REMOVE_CONNECT) {
			removeConnect((Component)e.getSource(),false);
		} else {
			throw new InternalError("no such action command.");
		}
	}

	protected boolean removeConfirm(Component com) {
		String [] arg = {this.toString()};
		String mes = MessageFormat.format
			(MainApp.getResString("DoYouRemoveElement{0}?"),arg);
		int ret = JOptionPane.showConfirmDialog
			(com,mes,MainApp.getResString("RemoveConfirm"),
			 JOptionPane.YES_NO_OPTION);
		if (ret != JOptionPane.YES_OPTION) return false;
		return true;
	}

	public void removeBranch(Component com,boolean direct) {
		if (!direct)
			if (!removeConfirm(com)) return;
		getElParent().getElementOperation().removeOpElement
			(getElementOperation());
		getTNParent().sendTreeChangedMessage();
	}

	public void removeConnect(Component com,boolean direct) {
		if (!direct)
			if (!removeConnectCheck
				(getElParent().getElementOperation(),
				 getElementOperation())) return;
		if (!removeConfirm(com)) return;
		removeConnect(getElParent().getElementOperation(),
					  getElementOperation());
		getTNParent().sendTreeChangedMessage();
	}

	protected void addObject(Component com) {
		String role = GuiUtil.inputDialog(com,"inputTagName","addElement");
		if (StringUtil.isNull(role)) return;
		ObjectModel object = ElementUtil.getObject(getModule(),role);
		if (getElementOperation().acceptOpElement(object)) {
			getElementOperation().addOpElements(ElementUtil.toArray(object));
		} else if (getElementOperation().acceptOpElement(HEDGEMODEL)) {
			getElementOperation().addOpElements
				(ElementUtil.toArray(ElementUtil.getRef(getModule(),object)));
		} else {
			throw new InternalError("Forbidden operation. ");
		}
		sendTreeChangedMessage();
	}

	protected void insertObject(Component com,ElementOperation child) {
		if(getElementOperation().getOpElements() == null ||
		   getElementOperation().getOpElements().length==0)
			throw new InternalError("Forbidden operation.");
		String role = GuiUtil.inputDialog
			(com,"inputTagName","insertElement");
		if (StringUtil.isNull(role)) return;
		ObjectModel object = ElementUtil.getObject(getModule(),role);
		if (reconnectCheck(getElementOperation(),object,child)) {
			// this object is module
			reconnect(getElementOperation(),object,child);
		} else if (reconnectCheck(getElementOperation(),HEDGEMODEL,child)) {
			//this object is element
			reconnect(getElementOperation(),ElementUtil.getRef(getModule(),object),child);
		} else {
			throw new InternalError("Forbidden operation. ");
		}
		sendTreeChangedMessage();
	}

	protected void addRef(Component com) {
		if (getElementOperation().acceptOpElement(HEDGEMODEL)) {
			ObjectModel [] elements = getModule().getAllObjects();
			String [] entries = new String[elements.length];
			for (int i=0;i<elements.length;i++) {
				String name = elements[i].getTagName();
				if (!elements[i].isLabelEqTag())
					name += " : (label="+elements[i].getLabel()+")";
				entries[i] = name;
			}
			SelectionDialog dlg = new SelectionDialog
				(JOptionPane.getFrameForComponent(com),
				 MainApp.getResString("selectElement"),
				 Arrays.asList(entries));
			dlg.show();
			if (dlg.getIndex() == -1) return;
			getElementOperation().addOpElements
				(ElementUtil.toArray(
									 ElementUtil.getRef(getModule(),elements[dlg.getIndex()])));
			sendTreeChangedMessage();
		} else 
			throw new InternalError("Forbidden operation.");
	}

	protected void addMixed(Component com) {
		getElementOperation().addOpElements
			(ElementUtil.toArray(ElementUtil.getMixed(getModule())));
		sendTreeChangedMessage();
	}

	protected void insertMixed(Component com,ElementOperation child) {
		if(getElementOperation().getOpElements() == null ||
		   getElementOperation().getOpElements().length==0)
			throw new InternalError("Forbidden operation.");
		if (reconnectCheck(getElementOperation(),ELEMENTMODEL,child)) {
			reconnect(getElementOperation(),ElementUtil.getMixed(getModule()),child);
		} else {
			throw new InternalError("Forbidden operation. ");
		}
		sendTreeChangedMessage();
	}

	protected void insertSequence(Component com,ElementOperation child) {
		if(getElementOperation().getOpElements() == null ||
		   getElementOperation().getOpElements().length==0)
			throw new InternalError("Forbidden operation.");
		if (reconnectCheck(getElementOperation(),HEDGEMODEL,child)) {
			reconnect(getElementOperation(),
					  ElementUtil.getSequence(getModule()),child);
		} else {
			throw new InternalError("Forbidden operation. ");
		}
		sendTreeChangedMessage();
	}
	protected void insertChoice(Component com,ElementOperation child) {
		if(getElementOperation().getOpElements() == null ||
		   getElementOperation().getOpElements().length==0)
			throw new InternalError("Forbidden operation.");
		if (reconnectCheck(getElementOperation(),HEDGEMODEL,child)) {
			reconnect(getElementOperation(),ElementUtil.getChoice(getModule()),child);
		} else {
			throw new InternalError("Forbidden operation. ");
		}
		sendTreeChangedMessage();
	}

	protected void addChoice(Component com) {
		getElementOperation().addOpElements
			(ElementUtil.toArray(ElementUtil.getChoice(getModule())));
		sendTreeChangedMessage();
	}

	protected void addSequence(Component com) {
		getElementOperation().addOpElements
			(ElementUtil.toArray(ElementUtil.getSequence(getModule())));
		sendTreeChangedMessage();
	}

	protected HedgeRuleElementModel chooseHedgeRule(Component com) {
		//exclude parent hedgeRule
		TNCommon pp = this;
		HedgeRuleElementModel exclude = null;
		while(pp != null) {
			if (pp instanceof TNHedgeRule) {
				exclude = (HedgeRuleElementModel)pp.getObject();
				break;
			}
			if (pp instanceof TNObject) {
				break;
			}
			pp = pp.getTNParent();
		}
		HedgeRuleElementModel [] elements = 
			getModule().getAllHedgeRules(exclude);
		//--------------------
		String [] entries = new String[elements.length];
		for (int i=0;i<elements.length;i++) {
			String name = elements[i].getLabel();
			entries[i] = name;
		}
		SelectionDialog dlg = new SelectionDialog
			(JOptionPane.getFrameForComponent(com),
			 MainApp.getResString("selectHedgeRule"),
			 Arrays.asList(entries));
		dlg.show();
		if (dlg.getIndex() == -1) return null;
		return elements[dlg.getIndex()];
	}

	protected void addHedgeRef(Component com) {
		if (getElementOperation().acceptOpElement(HEDGEMODEL)) {
			HedgeRuleElementModel ret = chooseHedgeRule(com);
			if (ret == null) return;
			getElementOperation().addOpElements
				(ElementUtil.toArray(
									 ElementUtil.getHedgeRef(getModule(),ret)));
			sendTreeChangedMessage();
		} else 
			throw new InternalError("Forbidden operation.");
	}

	protected void addNone(Component com) {
		getElementOperation().addOpElements
			(ElementUtil.toArray(ElementUtil.getNone(getModule())));
		sendTreeChangedMessage();
	}

	protected void addEmpty(Component com) {
		getElementOperation().addOpElements
			(ElementUtil.toArray(ElementUtil.getEmpty(getModule())));
		sendTreeChangedMessage();
	}

	public static Object [][] makeOrderChangeMenuResource(ElementOperation target,ElementOperation parent,ActionListener action) {
		if (!(parent instanceof AbstractMultiElementModel)) {
			throw new InternalError("Forbidden operation.");
		}
		AbstractMultiElementModel multi = (AbstractMultiElementModel)parent;
		List list = new ArrayList();
		list.add(new Object[] {
			"moveUpward",MOVE_UP,action,
			MainApp.getResString("IconMoveUp"),
			multi.canMoveElementUpward(target) ? Boolean.TRUE : Boolean.FALSE});
		list.add(new Object[] {
			"moveDownward",MOVE_DOWN,action,
			MainApp.getResString("IconMoveDown"),
			multi.canMoveElementDownward(target) ? Boolean.TRUE : Boolean.FALSE});
		Object [][] ret = new Object[list.size()][];
		return (Object[][]) list.toArray(ret);
	}
	
	public static Object [][] makeAddElementMenuResource(ElementOperation target,ActionListener action) {
		Boolean addok = 
			target.canAddElement() ? Boolean.TRUE : Boolean.FALSE;
		List list = new ArrayList();
		if (target.acceptOpElement(OBJECTMODEL)) {
			list.add(new Object[] 
				{"addElement",ADD_REF,action,
				 MainApp.getResString("IconElement"),
				 addok});
		}
		if (target.acceptOpElement(HEDGEMODEL)) {
			list.add(new Object[] 
				{"addRefElement",ADD_REF_REUSE,action,
				 MainApp.getResString("IconRef"),
				 addok});
		}
		if (target.acceptOpElement(ELEMENTMODEL)) {
			list.add(new Object[] 
				{"addMixed",ADD_MIXED,action,
				 MainApp.getResString("IconMixed"),
				 addok});
		}
		if (target.acceptOpElement(HEDGEMODEL)) {
			list.add(new Object[] 
				{"addSequence",ADD_SEQUENCE,action,
				 MainApp.getResString("IconSequence"),
				 addok});
			list.add(new Object[] 
				{"addChoice",ADD_CHOICE,action,
				 MainApp.getResString("IconChoice"),
				 addok});
			list.add(new Object[] 
				{"addHedgeRef",ADD_HEDGEREF,action,
				 MainApp.getResString("IconHedgeRef"),
				 addok});
			list.add(new Object[] 
				{"addNone",ADD_NONE,action,
				 MainApp.getResString("IconNone"),
				 addok});
			list.add(new Object[] 
				{"addEmpty",ADD_EMPTY,action,
				 MainApp.getResString("IconEmpty"),
				 addok});
		}
		Object [][] ret = new Object[list.size()][];
		return (Object[][]) list.toArray(ret);
	}

	public static Object [][] makeInsertElementMenuResource(ElementOperation target,ElementOperation child,ActionListener action) {
		if (child == null) 
			throw new InternalError
				("Object is null. (should be forbedden this operation)");
		List list = new ArrayList();
		if (reconnectCheck(target,OBJECTMODEL,child)) {
			list.add(new Object[] 
				{"insertElement",ADD_REF,action,
				 MainApp.getResString("IconElement"),
				 Boolean.TRUE});
		}
		if (reconnectCheck(target,ELEMENTMODEL,child)) {
			list.add(new Object[] 
				{"insertMixed",ADD_MIXED,action,
				 MainApp.getResString("IconMixed"),
				 Boolean.TRUE});
		}
		if (reconnectCheck(target,HEDGEMODEL,child)) {
			list.add(new Object[] 
				{"insertSequence",ADD_SEQUENCE,action,
				 MainApp.getResString("IconSequence"),
				 Boolean.TRUE});
			list.add(new Object[] 
				{"insertChoice",ADD_CHOICE,action,
				 MainApp.getResString("IconChoice"),
				 Boolean.TRUE});
		}
		Object [][] ret = new Object[list.size()][];
		return (Object[][]) list.toArray(ret);
	}

	Object [][] makeRemoveMenuResource(ElementOperation target,
									   ElementOperation parent,
									   ActionListener action) {
		if (!getElParent().isEditableObject()) return null;
		Object [][] ret = null;
		if (isEditableObject()) {
			ret = new Object [][] {
				{"RemoveConnect",REMOVE_CONNECT,action,
				 MainApp.getResString("IconEditRemoveThis"),
				 removeConnectCheck(parent,target) ? Boolean.TRUE:Boolean.FALSE},
				{"RemoveBranch",REMOVE_BRANCH,action,
				 MainApp.getResString("IconEditRemoveBranch"),Boolean.TRUE}
			};
		} else if (getElementOperation() instanceof ObjectModel) {
			ret = new Object [][] {
				{"RemoveBranch",REMOVE_BRANCH,action,
				 MainApp.getResString("IconEditRemoveBranch"),Boolean.TRUE}
			};
		}
		return ret;
	}

}
