/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.JPanel;
import javax.swing.JLabel;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import javax.swing.JPopupMenu;

public class TNEmpty extends TNElement  {

    EmptyElementModel none;

    public TNEmpty(TreeNode parent,MessageListener ms,
		   EmptyElementModel e) {
	super(parent,ms,"IconEmpty");
	none = e;
    }

    protected void setElements(TreeNode [] t) {
	setChildren(new TreeNode[0]);
    }

    public Object getObject() {
	return none;
    }

    JPanel panel;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.add(new JLabel(MainApp.getResString("noProperty")));
	}
	return panel;
    }

    public boolean getAllowsChildren() {
	return false;
    }

    public String toString() {
	return "[empty]";
    }
}



