/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Panel;
import java.awt.Component;
import java.awt.FlowLayout;
import jp.gr.java_conf.ccs2.comp.MessageListener;

public class TNHedgeRef extends TNElement  {

    HedgeRefElementModel hedgeRef;

    public TNHedgeRef(TreeNode parent,MessageListener ms,
		      HedgeRefElementModel m) {
	super(parent,ms,"IconHedgeRef");
	hedgeRef = m;
    }

    protected void setElements(TreeNode [] tn) {
	setChildren(new TreeNode[0]);
    }

    JPanel panel;
    JButton roleButton;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

	    ActionListener actionListener = new ActionListener() {
		    public void actionPerformed(ActionEvent e) {
			selectHedgeRule((Component)e.getSource());
		    }
		};
	    roleButton = new JButton("----");
	    roleButton.addActionListener(actionListener);
	    panel.add(setupButton(roleButton,"hedgeRef"));
	}
	roleButton.setText(hedgeRef.getAt().getLabel());

	return panel;
    }

    void selectHedgeRule(Component com) {
	HedgeRuleElementModel ret = chooseHedgeRule(com);
	if (ret == null) return;
	hedgeRef.setAt(ret);
	sendTreeChangedMessage();
    }

    public Object getObject() {
	return hedgeRef;
    }

    public boolean getAllowsChildren() {
	return false;
    }

    public String toString() {
	return "[HedgeRef : "+hedgeRef.getAt().getLabel()+"]";
    }

}
