/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Panel;
import java.awt.FlowLayout;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import java.awt.event.FocusListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.border.TitledBorder;
import java.awt.Component;

public class TNHedgeRule extends TNElement  {

    HedgeRuleElementModel hedgeRule;

    public TNHedgeRule(TreeNode parent,MessageListener ms,
		       HedgeRuleElementModel m) {
	super(parent,ms,"IconHedgeRule");
	hedgeRule = m;
    }

    protected void setElements(TreeNode [] tn) {
	setChildren(tn);
    }

    public void removeBranch(Component com,boolean direct) {
	if (!direct)
	    if (!removeConfirm(com)) return;
	ModuleModel mod = getModule();
	mod.removeHedgeRule(hedgeRule);
	getTNParent().sendTreeChangedMessage();
    }

    JPanel panel = null;
    JTextField nameField;
    JTextArea commentField;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

	    nameField = new JTextField(20);
	    panel.add(setupComponent(nameField,"HedgeRuleLabel"));

	    commentField = new JTextArea(3,20);
	    panel.add(setupTextArea(commentField,"HedgeRuleComment"));
	}

	updateComponentsFromData();
	return panel;
    }

    protected void updateDataFromComponents() {
	hedgeRule.setLabel(nameField.getText());
	hedgeRule.setComment(commentField.getText());
	sendRepaintMessage();
    }

    protected void updateComponentsFromData() {
	nameField.setText(hedgeRule.getLabel());
	commentField.setText(hedgeRule.getComment());
    }

    public Object getObject() {
	return hedgeRule;
    }

    public boolean getAllowsChildren() {
	return true;
    }

    public String toString() {
	return "["+hedgeRule.getLabel()+"]";
    }

}
