/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.StringUtil;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;

public class TNModule extends TNElement  {

    ModuleModel module;

    public TNModule(ModuleModel m,MessageListener s) {
	super(null,s,"IconModule");
	module = m;
    }

    protected TNModule(ModuleModel m,TNModule p,
		       MessageListener s) {
	super(p,s,"IconModule");
	module = m;
    }

    protected void setElements(TreeNode []tn) {
	setChildren(tn);
    }

    public Object getObject() {
	return module;
    }

    protected ModuleModel getMainModule() {
	return module;
    }

    protected Object [][] getPopupMenuResource() {
	Object [][] ret = super.getPopupMenuResource();
	Object [][] args = {
	    {null},
	    {"IncludeModule",INCLUDE_MODULE,getAddActionListener(),
	     MainApp.getResString("IconIncludeModule"),Boolean.TRUE}
	};
	return appendCustomMenusAfter(ret,args);
    }

    protected void menuAdd(ActionEvent e) {
	if (e.getActionCommand() == INCLUDE_MODULE) {
	    JFileChooser fc = new JFileChooser(System.getProperty("user.dir"));
	    fc.setFileFilter(MainApp.getRelaxFileFilter());
	    int returnVal = fc.showOpenDialog((Component)e.getSource());
	    if (returnVal == JFileChooser.APPROVE_OPTION) {
		File file = fc.getSelectedFile();
		try {
		    module.addIncludeModule(ModuleModel.loadModuleFromRelax
					    (file.getPath()));
		} catch (IOException em) {
		    JOptionPane.showMessageDialog
			((Component)e.getSource(),em.getMessage(),
			 MainApp.getResString("ErrorDialog"),
			 JOptionPane.ERROR_MESSAGE);
		    //e.printStackTrace();
		}
		sendTreeChangedMessage();
	    }
	    return;
	}
	super.menuAdd(e);
    }

    JPanel panel = null;
    JTextField verField,cverField,nsField;
    JTextArea commentField;
    public JPanel getPropertyPane() {
	if (panel == null) {
	    panel = new JPanel();
	    panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

	    commentField = new JTextArea(3,20);
	    panel.add(setupTextArea(commentField,"moduleComment"));

	    verField = new JTextField(8);
	    panel.add(setupComponent(verField, "moduleVersion"));

	    nsField = new JTextField(20);
	    panel.add(setupComponent(nsField,"moduleNameSpace"));

	    cverField = new JTextField(8);
	    panel.add(setupComponent(cverField,"moduleCoreVersion"));
	}
	updateComponentsFromData();
	return panel;
    }

    protected void updateDataFromComponents() {
	module.setModuleComment(commentField.getText());
	module.setModuleVersion(verField.getText());
	module.setTargetNameSpace(nsField.getText());
	module.setRelaxCoreVersion(cverField.getText());
    }

    protected void updateComponentsFromData() {
	commentField.setText(module.getModuleComment());
	verField.setText(module.getModuleVersion());
	nsField.setText(module.getTargetNameSpace());
	cverField.setText(module.getRelaxCoreVersion());
    }

    public String toString() {
	return "[Module]";
    }

}



