/* MkRelax, Visual Relax Editor
 *  Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;

public class TNModuleIncluded extends TNModule  {

    public TNModuleIncluded(ModuleModel m,TNModule p,MessageListener s) {
	super(m,p,s);
    }

    //override TNModule
    protected ModuleModel getMainModule() {
	if (getTNParent()!=null)
	    return getTNParent().getMainModule();
	MainApp.getAppContext().getMonitor().error("Stopped MainModule chain. : "+getClass().getName());
	throw new InternalError("Stopped MainModule chain.");
    }
    

    //override to customize popup menu
    protected Object [][] getPopupMenuResource() {
	Object [][] ret = {
	    {"RemoveModule",REMOVE_MODULE,getRemoveActionListener(),
	     MainApp.getResString("IconEditRemoveThis"),
	     Boolean.TRUE},
	    {"ReloadModule",RELOAD_MODULE,getRemoveActionListener(),
	     MainApp.getResString("IconReloadModule"),
	     Boolean.TRUE}
	};
	return ret;
    }

    protected void menuRemove(ActionEvent e) {
	if (e.getActionCommand() == REMOVE_MODULE) {
	    removeModule(e);
	    return;
	} else if (e.getActionCommand() == RELOAD_MODULE) {
	    reloadModule(e);
	    return;
	}
	throw new InternalError("No such event : "+e.getActionCommand());
    }

    protected void removeModule(ActionEvent e) {
	String [] ret = ElementUtil.checkUsedObject(getModule(),getMainModule());
	if (ret == null) {
	    if (removeConfirm((Component)e.getSource())) {
		getMainModule().removeIncludeModule(getModule());
		sendTreeChangedMessage();
	    }
	    return;
	}
	String tt = MainApp.getResString("UsingFollowingObjects{0}");
	StringBuffer sb = new StringBuffer();
	String ft = MainApp.getResString("UsingFollowingObjectsItem{0}");
	for (int i=0;i<ret.length;i++) {
	    sb.append(MessageFormat.format(ft,new String[] {ret[i]}));
	}
	String mes = MessageFormat.format(tt,new String [] {sb.toString()});
	JOptionPane.showMessageDialog((Component)e.getSource(),mes,
				      MainApp.getResString("RemoveConfirm"),
				      JOptionPane.INFORMATION_MESSAGE);
    }

    protected void reloadModule(ActionEvent e) {
	ArrayList list = new ArrayList();
	list.add(getModule());
	getMessageListener().message(null,MessageListener.RECALC,list);
    }

    public String toString() {
	return "[Module ("+module.getModuleName()+")]";
    }


}
