/* MkRelax, Visual Relax Editor
 *	Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import javax.swing.tree.TreeNode;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.util.StringUtil;
import java.util.Arrays;
import java.text.MessageFormat;


public abstract class TNMultiElement extends TNElement	{

	private AbstractMultiElementModel multi;

	public TNMultiElement(TreeNode parent,MessageListener ms,
						  AbstractMultiElementModel m,String iconRes) {
		super(parent,ms,iconRes);
		multi = m;
	}

	protected AbstractMultiElementModel getModel() {
		return multi;
	}

	protected void setElements(TreeNode [] tns) {
		setChildren(tns);
	}

	public Object getObject() {
		return multi;
	}


	JPanel panel = null;
	JComboBox occursBox;
	public JPanel getPropertyPane() {
		if (panel == null) {
			panel = new JPanel();
			panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
			occursBox = new JComboBox(AbstractElementModel.occurSymbols);
			panel.add(setupComponent(occursBox,"hedgeOccurs"));
		}
		updateComponentsFromData();
		return panel;
	}

	protected void updateDataFromComponents() {
		multi.setOccurs(occursBox.getSelectedIndex());
		sendRepaintMessage();
	}

	protected void updateComponentsFromData() {
		occursBox.setSelectedIndex(multi.getOccurs());
	}

	protected void changeMulti(AbstractMultiElementModel multi) {
		TNElement parent = getElParent();
		if(parent==null)
			throw new InternalError("Forbidden operation.");
		if (getElementOperation().getOpElements() == null ||
			getElementOperation().getOpElements().length == 0) {
			removeBranch(null,true);
			parent.getElementOperation().addOpElements(ElementUtil.toArray(multi));
			multi.setOccurs(((AbstractElementModel)getElementOperation()).getOccurs());
		} else if (reconnectCheck(parent.getElementOperation(),HEDGEMODEL,
								  getElementOperation())) {
			reconnect(parent.getElementOperation(),multi,
					  getElementOperation());
			removeConnect(multi,getElementOperation());
			multi.setOccurs(((AbstractElementModel)getElementOperation()).getOccurs());
		} else {
			throw new InternalError("Forbidden operation. ");
		}
		sendTreeChangedMessage();
	}

	protected static final String CHANGE_SEQ = "change_seq";
	protected static final String CHANGE_CHOICE = "change_choice";

	public String toString(String res) {
		String ret = MainApp.getResString(res);
		String arg = "";
		if (getModel().getOccurs() != getModel().OCCURS_ONE)
			arg = " ["+getModel().getOccurSymbol()+"]";
		return MessageFormat.format(ret,new String[]{arg});
	}

}



