/* MkRelax, Visual Relax Editor
 *	Copyright (C) 2001-2002 SAKURAI, Masashi (m.sakurai@cmt.phys.kyushu-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.ccs2.tool.mkrelax.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.*;
import javax.swing.tree.TreeNode;
import jp.gr.java_conf.ccs2.comp.SelectionDialog;
import jp.gr.java_conf.ccs2.comp.MessageListener;
import jp.gr.java_conf.ccs2.util.StringUtil;
import jp.gr.java_conf.ccs2.tool.mkrelax.*;
import java.text.MessageFormat;
import javax.swing.border.TitledBorder;

public class TNObject extends TNElement	 {

	boolean shadow = false;
	ObjectModel object;
	RefElementModel ref = null;

	public TNObject(TreeNode parent,MessageListener ms,
					ObjectModel obj) {
		this(parent,ms,obj,false);
	}

	public TNObject(TreeNode parent,MessageListener ms,
					ObjectModel obj,boolean shadow) {
		super(parent,ms,"IconElement");
		object = obj;
		this.shadow=shadow;
	}

	protected void setRef(RefElementModel r) {
		ref = r;
	}
	public RefElementModel getRef() {
		return ref;
	}

	public Object getObject() {
		return object;
	}

	//called by ObjectTreeModel
	boolean isShadow() {
		return shadow;
	}

	//Should be called to get ready to show!
	protected void setElements(TreeNode [] em) {
		List cc = new ArrayList();
		AttributeModel [] am = object.getAttributes();
		for (int i=0;i<am.length;i++) {
			if (am[i] instanceof ConcreteAttributeModel) {
				cc.add(new TNConAttribute
					(this,getMessageListener(),
					 (ConcreteAttributeModel)am[i]));
				continue;
			}
			if (am[i] instanceof AttributeRefModel) {
				cc.add(new TNAttributeRef
					(this,getMessageListener(),
					 (AttributeRefModel)am[i]));
				continue;
			}
		}
		if (em != null && em.length != 0) {
			cc.add(em[0]);
		}
		TreeNode [] tts = new TreeNode[cc.size()];
		tts = (TreeNode[])cc.toArray(tts);
		setChildren(tts);
	}

	JPanel panel = null;
	JButton typeButton;
	JComboBox occursBox;
	JCheckBox exportCheck;
	JTextField tagField,labelField;
	JTextArea commentField;
	public JPanel getPropertyPane() {
		if (panel == null) {
			panel = new JPanel();
			panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
			String [] args = {object.getParentModule().getModuleName()};
			panel.add(new JLabel(MessageFormat.format(MainApp.getResString("BelongTo{0}"),args)));

			tagField = new JTextField(20);
			panel.add(setupComponent(tagField,"objectTag"));

			labelField = new JTextField(20);
			panel.add(setupComponent(labelField,"objectLabel"));

			commentField = new JTextArea(3,20);
			panel.add(setupTextArea(commentField,"objectComment"));

			occursBox = new JComboBox(AbstractElementModel.occurSymbols);
			panel.add(setupComponent(occursBox,"objectOccurs"));

			exportCheck = new JCheckBox();
			panel.add(setupComponent(exportCheck,"objectExport"));

			typeButton = new JButton("-----");
			typeButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						selectDataType();
					}
				});
			panel.add(setupButton(typeButton,"objectType"));
		}
		updateComponentsFromData();
		return panel;
	}

	void selectDataType() {
		SelectionDialog dialog = new SelectionDialog
			(JOptionPane.getFrameForComponent(typeButton),
			 MainApp.getResString("selectDataType"),
			 Arrays.asList(DataType.dataTypes));
		dialog.show();
		if (dialog.getIndex() == -1) return;
		typeButton.setText(DataType.dataTypes[dialog.getIndex()].getTypeName());
		object.setType(DataType.dataTypes[dialog.getIndex()]);
		clearPopupMenu();
		sendRepaintMessage();
	}

	protected void updateDataFromComponents() {
		object.setTagName(tagField.getText());
		object.setLabel(labelField.getText());
		object.setComment(commentField.getText());
		if (ref != null) {
			ref.setOccurs(occursBox.getSelectedIndex());
		}
		object.setExportable(exportCheck.isSelected());
		sendRepaintMessage();
	}

	protected void updateComponentsFromData() {
		tagField.setText(object.getTagName());
		labelField.setText(object.getLabel());
		commentField.setText(object.getComment());
		if (ref != null) {
			occursBox.setSelectedIndex(ref.getOccurs());
		}
		exportCheck.setSelected(object.isExportable());
		typeButton.setText(object.getType().getTypeName());
		typeButton.setEnabled( object.getElement() == null && 
							   isEditableObject() );
		occursBox.setEnabled( ref != null && 
							  getElParent().isEditableObject());
	}
	

	protected Object [][] getPopupMenuResource() {
		Object [][] args = super.getPopupMenuResource();
		if (isEditableObject()) {
			Object [][] attMenus = {
				{"addAttribute",ADD_ATTRIBUTE,
				 getAddActionListener(),
				 MainApp.getResString("IconAttribute"),
				 Boolean.TRUE},
				{"addAttributeRef",ADD_ATTREF,
				 getAddActionListener(),
				 MainApp.getResString("IconAttPoolRef"),
				 Boolean.TRUE},
				{null},
			};
			args = appendCustomMenusBefore(args,attMenus);
		}
		return args;
	}

	protected void menuAdd(ActionEvent e) {
		if (e.getActionCommand() == ADD_ATTRIBUTE) {
			addAttribute();
		} else if (e.getActionCommand() == ADD_ATTREF) {
			addAttributeRef((Component)e.getSource());
		} else {
			super.menuAdd(e);
		}
	}

	void addAttribute() {
		GuiUtil.addAttribute(popMenu,object);
		sendTreeChangedMessage();
	}

	void addAttributeRef(Component com) {
		AttributePoolModel attpool = chooseAttributePool(com);
		if (attpool == null) return;
		object.addAttribute(ElementUtil.getAttributeRef(attpool));
		sendTreeChangedMessage();
	}

	public String toString() {
		String ret = object.getTagName();
		if (!object.isLabelEqTag())
			ret += "("+object.getLabel()+")";
		ret = "<"+ret;
		if (shadow) {
			ret += "...(nested) ";
		} else {
			if (object.getType() != DataType.RLX_ELEMENT) {
				ret += " : "+object.getType().getTypeName();
			}
			if (ref != null) {
				if (ref.getOccurs() != ref.OCCURS_ONE) {
					ret += " ["+ref.getOccurSymbol()+"]";
				}
			}
		}
		ret += ">";
		return ret;
	}
	
}
