package jp.gr.java_conf.ccs2.tool.mkrelax.relaxer;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Option</b> is generated by Relaxer based on relaxerOptions.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="option">
 *   <tag>
 *     <attribute name="default" required="true" type="string"/>
 *     <ref role="optionAtt"/>
 *   </tag>
 *   <hedgeRef label="content"/>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="option"&gt;
 *   &lt;tag&gt;
 *     &lt;attribute name="default" required="true" type="string"/&gt;
 *     &lt;ref role="optionAtt"/&gt;
 *   &lt;/tag&gt;
 *   &lt;hedgeRef label="content"/&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxerOptions.rlx 1.0 (Sun Oct 07 01:23:04 JST 2001)
 * @author  Relaxer 0.14.2 (http://www.relaxer.org)
 */
public class Option implements java.io.Serializable {
    private String default_;
    private String name_;
    private Boolean force_;
    // List<Description>
    private java.util.List description_ = new java.util.ArrayList();

    /**
     * Creates a <code>Option</code>.
     *
     */
    public Option() {
    }

    /**
     * Creates a <code>Option</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Option(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Option</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Option(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Option</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Option(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Option</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Option</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Option</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Option</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Option</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Option</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Option</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Option</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Option</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        default_ = URelaxer.getAttributePropertyAsString(element, "default");
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        force_ = URelaxer.getAttributePropertyAsBooleanObject(element, "force");
        description_.clear();
        while (!stack.isEmptyElement()) {
            if (Description.isMatch(stack)) {
                addDescription(new Description(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("option");
        int size;
        URelaxer.setAttributePropertyByString(element, "default", this.default_);
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        if (this.force_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "force", this.force_);
        }
        size = this.description_.size();
        for (int i = 0;i < size;i++) {
            Description value = (Description)this.description_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Option</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Option</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Option</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Option</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Option</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Initializes the <code>Option</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_VALIDATION));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>default</b>.
     *
     * @return String
     */
    public final String getDefault() {
        return (default_);
    }

    /**
     * Sets the String property <b>default</b>.
     *
     * @param defaultValue
     */
    public final void setDefault(String defaultValue) {
        this.default_ = defaultValue;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the boolean property <b>force</b>.
     *
     * @exception IllegalStateException
     * @return boolean
     */
    public boolean getForce() throws IllegalStateException {
        if (force_ == null) {
            throw (new IllegalStateException("force_"));
        }
        return (force_.booleanValue());
    }

    /**
     * Gets the boolean property <b>force</b>.
     *
     * @exception IllegalStateException
     * @return Boolean
     */
    public Boolean getForceAsBoolean() throws IllegalStateException {
        return (force_);
    }

    /**
     * Check the boolean property <b>force</b>.
     *
     * @return boolean
     */
    public boolean checkForce() {
        return (force_ != null);
    }

    /**
     * Sets the boolean property <b>force</b>.
     *
     * @param force
     */
    public void setForce(boolean force) {
        this.force_ = new Boolean(force);
    }

    /**
     * Sets the boolean property <b>force</b>.
     *
     * @param force
     */
    public void setForce(Boolean force) {
        this.force_ = force;
    }

    /**
     * Gets the Description property <b>description</b>.
     *
     * @return Description[]
     */
    public final Description[] getDescription() {
        Description[] array = new Description[description_.size()];
        return ((Description[])description_.toArray(array));
    }

    /**
     * Sets the Description property <b>description</b>.
     *
     * @param description
     */
    public final void setDescription(Description[] description) {
        this.description_.clear();
        this.description_.addAll(java.util.Arrays.asList(description));
    }

    /**
     * Sets the Description property <b>description</b>.
     *
     * @param description
     */
    public final void setDescription(Description description) {
        this.description_.clear();
        this.description_.add(description);
    }

    /**
     * Adds the Description property <b>description</b>.
     *
     * @param description
     */
    public final void addDescription(Description description) {
        this.description_.add(description);
    }

    /**
     * Gets number of the Description property <b>description</b>.
     *
     * @return int
     */
    public final int getDescriptionCount() {
        return (description_.size());
    }

    /**
     * Gets the Description property <b>description</b> by index.
     *
     * @param index
     * @return Description
     */
    public final Description getDescription(int index) {
        return ((Description)description_.get(index));
    }

    /**
     * Sets the Description property <b>description</b> by index.
     *
     * @param index
     * @param description
     */
    public final void setDescription(int index, Description description) {
        this.description_.set(index, description);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<option");
        buffer.append(" default=\"");
        buffer.append(URelaxer.escapeAttrQuot(getDefault()));
        buffer.append("\"");
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(getName()));
        buffer.append("\"");
        if (force_ != null) {
            buffer.append(" force=\"");
            buffer.append(new Boolean(getForce()).toString());
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.description_.size();
        for (int i = 0;i < size;i++) {
            Description value = (Description)this.description_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</option>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<option");
        buffer.print(" default=\"");
        buffer.print(URelaxer.escapeAttrQuot(getDefault()));
        buffer.print("\"");
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(getName()));
        buffer.print("\"");
        if (force_ != null) {
            buffer.print(" force=\"");
            buffer.print(new Boolean(getForce()).toString());
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.description_.size();
        for (int i = 0;i < size;i++) {
            Description value = (Description)this.description_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</option>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Option</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "option")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Description.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Option</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Option</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
